/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.BitSet;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.lib.collection.HashList;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.Region;
import net.minecraftforge.fluids.IFluidBlock;

public class ThreadMinerSearch
extends Thread {
    private final TileEntityDigitalMiner tile;
    private final Long2ObjectMap<BitSet> oresToMine = new Long2ObjectOpenHashMap();
    private Region chunkCache;
    public State state = State.IDLE;
    public int found = 0;

    public ThreadMinerSearch(TileEntityDigitalMiner tile) {
        this.tile = tile;
    }

    public void setChunkCache(Region cache) {
        this.chunkCache = cache;
    }

    @Override
    public void run() {
        this.state = State.SEARCHING;
        HashList<MinerFilter<?>> filters = this.tile.getFilters();
        if (!this.tile.getInverse() && filters.isEmpty()) {
            this.state = State.FINISHED;
            return;
        }
        Object2ObjectOpenHashMap acceptedItems = new Object2ObjectOpenHashMap();
        BlockPos pos = this.tile.getStartingPos();
        int diameter = this.tile.getDiameter();
        int size = this.tile.getTotalSize();
        BlockPos minerPos = this.tile.func_174877_v();
        for (int i = 0; i < size; ++i) {
            Block info;
            BlockState state;
            if (this.tile.func_145837_r()) {
                return;
            }
            BlockPos testPos = pos.func_177982_a(i % diameter, i / diameter / diameter, i / diameter % diameter);
            if (minerPos.equals((Object)testPos) || WorldUtils.getTileEntity(TileEntityBoundingBlock.class, (IBlockReader)this.chunkCache, testPos) != null || (state = this.chunkCache.func_180495_p(testPos)).isAir((IBlockReader)this.chunkCache, testPos) || state.func_235714_a_(MekanismTags.Blocks.MINER_BLACKLIST) || state.func_185887_b((IBlockReader)this.chunkCache, testPos) < 0.0f || (info = state.func_177230_c()) instanceof FlowingFluidBlock || info instanceof IFluidBlock) continue;
            MinerFilter filterFound = null;
            if (acceptedItems.containsKey(info)) {
                filterFound = (MinerFilter)acceptedItems.get(info);
            } else {
                if (this.tile.isReplaceTarget(info.func_199767_j())) continue;
                for (MinerFilter minerFilter : filters) {
                    if (!minerFilter.canFilter(state)) continue;
                    filterFound = minerFilter;
                    break;
                }
                acceptedItems.put(info, filterFound);
            }
            if (this.tile.getInverse() != (filterFound == null)) continue;
            long chunk = WorldUtils.getChunkPosAsLong(testPos);
            ((BitSet)this.oresToMine.computeIfAbsent(chunk, k -> new BitSet())).set(i);
            ++this.found;
        }
        this.state = State.FINISHED;
        this.chunkCache = null;
        this.tile.updateFromSearch(this.oresToMine, this.found);
    }

    public static enum State implements IHasTextComponent
    {
        IDLE(MekanismLang.MINER_IDLE),
        SEARCHING(MekanismLang.MINER_SEARCHING),
        PAUSED(MekanismLang.MINER_PAUSED),
        FINISHED(MekanismLang.MINER_READY);

        private static final State[] MODES;
        private final ILangEntry langEntry;

        private State(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.langEntry.translate(new Object[0]);
        }

        public static State byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = State.values();
        }
    }
}

