/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.function.Consumer;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.computercraft.CCEnergyHelper;
import mekanism.common.integration.computer.computercraft.MekanismPeripheral;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class ComputerCapabilityHelper {
    @CapabilityInject(value=IPeripheral.class)
    public static Capability<IPeripheral> COMPUTER_CRAFT_CAPABILITY;

    public static <TILE extends TileEntity> void addComputerCapabilities(TILE tile, Consumer<ICapabilityResolver> capabilityAdder) {
        if (((IComputerTile)tile).hasComputerSupport() && Mekanism.hooks.CCLoaded) {
            capabilityAdder.accept(ComputerCapabilityHelper.getComputerCraftCapability(tile));
        }
    }

    private static <TILE extends TileEntity> ICapabilityResolver getComputerCraftCapability(TILE tile) {
        if (((IComputerTile)tile).isComputerCapabilityPersistent()) {
            return BasicCapabilityResolver.persistent(COMPUTER_CRAFT_CAPABILITY, () -> MekanismPeripheral.create(tile));
        }
        return BasicCapabilityResolver.create(COMPUTER_CRAFT_CAPABILITY, () -> MekanismPeripheral.create(tile));
    }

    public static void registerCCMathHelper() {
        ComputerCraftAPI.registerAPIFactory(CCEnergyHelper::create);
    }
}

