/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.bracket;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.BracketValidator;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import mekanism.api.MekanismAPI;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.api.BracketValidators")
public class CrTBracketValidators {
    @ZenCodeType.Method
    @BracketValidator(value="gas")
    public static boolean validateGasStack(String tokens) {
        return CrTBracketValidators.validate("gas", tokens, MekanismAPI.gasRegistry());
    }

    @ZenCodeType.Method
    @BracketValidator(value="infuse_type")
    public static boolean validateInfusionStack(String tokens) {
        return CrTBracketValidators.validate("infuse_type", tokens, MekanismAPI.infuseTypeRegistry());
    }

    @ZenCodeType.Method
    @BracketValidator(value="pigment")
    public static boolean validatePigmentStack(String tokens) {
        return CrTBracketValidators.validate("pigment", tokens, MekanismAPI.pigmentRegistry());
    }

    @ZenCodeType.Method
    @BracketValidator(value="slurry")
    public static boolean validateSlurryStack(String tokens) {
        return CrTBracketValidators.validate("slurry", tokens, MekanismAPI.slurryRegistry());
    }

    @ZenCodeType.Method
    @BracketValidator(value="robit_skin")
    public static boolean validateRobitSkin(String tokens) {
        return CrTBracketValidators.validate("robit_skin", tokens, MekanismAPI.robitSkinRegistry());
    }

    @ZenCodeType.Method
    @BracketValidator(value="module_data")
    public static boolean validateModuleData(String tokens) {
        return CrTBracketValidators.validate("module_data", tokens, MekanismAPI.moduleRegistry());
    }

    private static boolean validate(String bracket, String tokens, IForgeRegistry<?> registry) {
        ResourceLocation registryName = ResourceLocation.func_208304_a((String)tokens);
        if (registryName == null) {
            CraftTweakerAPI.logError((String)"Could not get BEP <%s:%s>. Syntax is <%1$s:modid:%1$s_name>", (Object[])new Object[]{bracket, tokens});
            return false;
        }
        if (CrTBracketValidators.isRegistryUnlocked(registry) || registry.containsKey(registryName)) {
            return true;
        }
        String typeName = bracket.replace("_", " ");
        CraftTweakerAPI.logError((String)("Could not get %s for <%s:%s" + tokens + ">, %1$s does not appear to exist!"), (Object[])new Object[]{typeName, bracket, tokens});
        return false;
    }

    private static boolean isRegistryUnlocked(IForgeRegistry<?> registry) {
        return registry instanceof ForgeRegistry && !((ForgeRegistry)registry).isLocked();
    }
}

