/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.impl.tag.MCTag;
import java.util.function.Function;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import net.minecraft.tags.ITag;

public class CrTIngredientHelper {
    static void assertValidAmount(String ingredientType, long amount) {
        if (amount <= 0L) {
            throw new IllegalArgumentException(ingredientType + " can only be created with a size of at least one. Received size was: " + amount);
        }
    }

    static <TYPE, CRT_TYPE> ITag<TYPE> assertValidAndGet(MCTag<CRT_TYPE> crtTag, long amount, Function<MCTag<CRT_TYPE>, ITag<TYPE>> getter, String ingredientType) {
        CrTIngredientHelper.assertValidAmount(ingredientType, amount);
        return CrTUtils.validateTagAndGet(crtTag, getter);
    }

    static void assertValid(Chemical<?> instance, long amount, String ingredientType, String chemicalType) {
        CrTIngredientHelper.assertValidAmount(ingredientType, amount);
        if (instance.isEmptyType()) {
            throw new IllegalArgumentException(ingredientType + " cannot be created from an empty " + chemicalType + ".");
        }
    }

    static void assertValid(ICrTChemicalStack<?, ?, ?> instance, String ingredientType) {
        if (instance.isEmpty()) {
            throw new IllegalArgumentException(ingredientType + " cannot be created from an empty stack.");
        }
    }

    @SafeVarargs
    static <INGREDIENT extends InputIngredient<?>> INGREDIENT createMulti(String ingredientType, Function<INGREDIENT[], INGREDIENT> multiCreator, INGREDIENT ... ingredients) {
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("Multi " + ingredientType + " ingredients cannot be made out of no ingredients!");
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        return (INGREDIENT)((InputIngredient)multiCreator.apply(ingredients));
    }
}

