/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.JSONConverter;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.MCTagWithAmount;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.gson.JsonElement;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.api.recipes.inputs.chemical.PigmentStackIngredient;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.ingredient.CrTIngredientHelper;
import mekanism.common.integration.crafttweaker.tag.CrTPigmentTagManager;
import net.minecraft.tags.ITag;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=PigmentStackIngredient.class, zenCodeName="mods.mekanism.api.ingredient.ChemicalStackIngredient.PigmentStackIngredient")
public class CrTPigmentStackIngredient {
    private CrTPigmentStackIngredient() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static PigmentStackIngredient from(Pigment instance, long amount) {
        CrTIngredientHelper.assertValid(instance, amount, "PigmentStackIngredients", "pigment");
        return PigmentStackIngredient.from(instance, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static PigmentStackIngredient from(ICrTChemicalStack.ICrTPigmentStack instance) {
        CrTIngredientHelper.assertValid(instance, "PigmentStackIngredients");
        return PigmentStackIngredient.from((PigmentStack)instance.getImmutableInternal());
    }

    @ZenCodeType.StaticExpansionMethod
    public static PigmentStackIngredient from(MCTag<Pigment> pigmentTag, long amount) {
        ITag tag = CrTIngredientHelper.assertValidAndGet(pigmentTag, amount, CrTPigmentTagManager.INSTANCE::getInternal, "PigmentStackIngredients");
        return PigmentStackIngredient.from(tag, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static PigmentStackIngredient from(MCTagWithAmount<Pigment> pigmentTag) {
        return CrTPigmentStackIngredient.from((MCTag<Pigment>)pigmentTag.getTag(), (long)pigmentTag.getAmount());
    }

    @ZenCodeType.StaticExpansionMethod
    public static PigmentStackIngredient createMulti(PigmentStackIngredient ... ingredients) {
        return (PigmentStackIngredient)CrTIngredientHelper.createMulti((String)"PigmentStackIngredients", PigmentStackIngredient::createMulti, (InputIngredient[])ingredients);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(PigmentStackIngredient _this) {
        return JSONConverter.convert((JsonElement)_this.serialize());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static PigmentStackIngredient or(PigmentStackIngredient _this, PigmentStackIngredient other) {
        return PigmentStackIngredient.createMulti(_this, other);
    }
}

