/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.ingredient;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.JSONConverter;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.MCTagWithAmount;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.google.gson.JsonElement;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.api.recipes.inputs.chemical.SlurryStackIngredient;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.ingredient.CrTIngredientHelper;
import mekanism.common.integration.crafttweaker.tag.CrTSlurryTagManager;
import net.minecraft.tags.ITag;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@NativeTypeRegistration(value=SlurryStackIngredient.class, zenCodeName="mods.mekanism.api.ingredient.ChemicalStackIngredient.SlurryStackIngredient")
public class CrTSlurryStackIngredient {
    private CrTSlurryStackIngredient() {
    }

    @ZenCodeType.StaticExpansionMethod
    public static SlurryStackIngredient from(Slurry instance, long amount) {
        CrTIngredientHelper.assertValid(instance, amount, "SlurryStackIngredients", "slurry");
        return SlurryStackIngredient.from(instance, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static SlurryStackIngredient from(ICrTChemicalStack.ICrTSlurryStack instance) {
        CrTIngredientHelper.assertValid(instance, "SlurryStackIngredients");
        return SlurryStackIngredient.from((SlurryStack)instance.getImmutableInternal());
    }

    @ZenCodeType.StaticExpansionMethod
    public static SlurryStackIngredient from(MCTag<Slurry> slurryTag, long amount) {
        ITag tag = CrTIngredientHelper.assertValidAndGet(slurryTag, amount, CrTSlurryTagManager.INSTANCE::getInternal, "SlurryStackIngredients");
        return SlurryStackIngredient.from(tag, amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static SlurryStackIngredient from(MCTagWithAmount<Slurry> slurryTag) {
        return CrTSlurryStackIngredient.from((MCTag<Slurry>)slurryTag.getTag(), (long)slurryTag.getAmount());
    }

    @ZenCodeType.StaticExpansionMethod
    public static SlurryStackIngredient createMulti(SlurryStackIngredient ... ingredients) {
        return (SlurryStackIngredient)CrTIngredientHelper.createMulti((String)"SlurryStackIngredients", SlurryStackIngredient::createMulti, (InputIngredient[])ingredients);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public static IData asIData(SlurryStackIngredient _this) {
        return JSONConverter.convert((JsonElement)_this.serialize());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    public static SlurryStackIngredient or(SlurryStackIngredient _this, SlurryStackIngredient other) {
        return SlurryStackIngredient.createMulti(_this, other);
    }
}

