/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.recipes.ItemStackToPigmentRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.PigmentExtractingIRecipe;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.ItemStackToPigment")
public abstract class ItemStackToPigmentRecipeManager
extends MekanismRecipeManager<ItemStackToPigmentRecipe> {
    protected ItemStackToPigmentRecipeManager(MekanismRecipeType<ItemStackToPigmentRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, ICrTChemicalStack.ICrTPigmentStack output) {
        this.addRecipe(this.makeRecipe(this.getAndValidateName(name), input, this.getAndValidateNotEmpty(output)));
    }

    protected abstract ItemStackToPigmentRecipe makeRecipe(ResourceLocation var1, ItemStackIngredient var2, PigmentStack var3);

    @Override
    protected MekanismRecipeManager.ActionAddMekanismRecipe getAction(ItemStackToPigmentRecipe recipe) {
        return new MekanismRecipeManager.ActionAddMekanismRecipe(recipe){

            @Override
            protected String describeOutputs() {
                return CrTUtils.describeOutputs(((ItemStackToPigmentRecipe)this.getRecipe()).getOutputDefinitionNew(), CrTChemicalStack.CrTPigmentStack::new);
            }
        };
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.ItemStackToPigment.PigmentExtracting")
    public static class PigmentExtractingRecipeManager
    extends ItemStackToPigmentRecipeManager {
        public static final PigmentExtractingRecipeManager INSTANCE = new PigmentExtractingRecipeManager();

        private PigmentExtractingRecipeManager() {
            super(MekanismRecipeType.PIGMENT_EXTRACTING);
        }

        @Override
        protected ItemStackToPigmentRecipe makeRecipe(ResourceLocation id, ItemStackIngredient input, PigmentStack output) {
            return new PigmentExtractingIRecipe(id, input, output);
        }
    }
}

