/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.tag;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagAdd;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagCreate;
import com.blamejared.crafttweaker.impl.actions.tags.ActionTagRemove;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.blamejared.crafttweaker.impl.tag.manager.TagManager;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalTags;
import mekanism.api.providers.IChemicalProvider;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.Tag;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.api.tag.ChemicalTagManager")
public abstract class CrTChemicalTagManager<CHEMICAL extends Chemical<CHEMICAL>>
implements TagManager<CHEMICAL> {
    private final ChemicalTags<CHEMICAL> chemicalTags;

    protected CrTChemicalTagManager(ChemicalTags<CHEMICAL> chemicalTags) {
        this.chemicalTags = chemicalTags;
    }

    public void addElements(MCTag<CHEMICAL> to, List<CHEMICAL> toAdd) {
        ITag<CHEMICAL> internal = this.getInternal(to);
        List<CHEMICAL> itemsFromDefinitions = this.getChemicals(toAdd);
        if (internal == null) {
            Tag tagFromContents = Tag.func_241286_a_((Set)Sets.newHashSet(itemsFromDefinitions));
            CraftTweakerAPI.apply((IAction)new ActionTagCreate(this.getTagCollection(), (ITag)tagFromContents, to));
        } else {
            CraftTweakerAPI.apply((IAction)new ActionTagAdd(internal, itemsFromDefinitions, to));
        }
    }

    public void removeElements(MCTag<CHEMICAL> from, List<CHEMICAL> toRemove) {
        ITag<CHEMICAL> internal = this.getInternal(from);
        List<CHEMICAL> chemicals = this.getChemicals(toRemove);
        CraftTweakerAPI.apply((IAction)new ActionTagRemove(internal, chemicals, from));
    }

    private List<CHEMICAL> getChemicals(List<CHEMICAL> toConvert) {
        return toConvert.stream().map(IChemicalProvider::getChemical).collect(Collectors.toList());
    }

    public List<CHEMICAL> getElementsInTag(MCTag<CHEMICAL> theTag) {
        ITag<CHEMICAL> internal = this.getInternal(theTag);
        if (internal == null) {
            return Collections.emptyList();
        }
        return internal.func_230236_b_();
    }

    public ITagCollection<CHEMICAL> getTagCollection() {
        return this.chemicalTags.getCollection();
    }

    @Nullable
    public ITag<CHEMICAL> getInternal(MCTag<CHEMICAL> theTag) {
        return this.getTagCollection().func_199910_a(theTag.getIdInternal());
    }
}

