/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSGas;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

@RecipeTypeMapper
public class ElectrolysisRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "MekElectrolysis";
    }

    public String getDescription() {
        return "Maps Mekanism electrolytic separator recipes.";
    }

    public boolean canHandle(IRecipeType<?> recipeType) {
        return recipeType == MekanismRecipeType.SEPARATING;
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, IRecipe<?> iRecipe, INSSFakeGroupManager groupManager) {
        if (!(iRecipe instanceof ElectrolysisRecipe)) {
            return false;
        }
        boolean handled = false;
        ElectrolysisRecipe recipe = (ElectrolysisRecipe)iRecipe;
        FluidStackIngredient input = recipe.getInput();
        for (FluidStack representation : input.getRepresentations()) {
            Pair<@NonNull GasStack, @NonNull GasStack> output = recipe.getOutput(representation);
            GasStack leftOutput = (GasStack)output.getLeft();
            GasStack rightOutput = (GasStack)output.getRight();
            if (leftOutput.isEmpty() || rightOutput.isEmpty()) continue;
            NSSFluid nssInput = NSSFluid.createFluid((FluidStack)representation);
            NSSGas nssLeftOutput = NSSGas.createGas(leftOutput);
            NSSGas nssRightOutput = NSSGas.createGas(rightOutput);
            IngredientHelper ingredientHelper = new IngredientHelper(mapper);
            ingredientHelper.put((NormalizedSimpleStack)nssInput, representation.getAmount());
            ingredientHelper.put((NormalizedSimpleStack)nssRightOutput, -rightOutput.getAmount());
            if (ingredientHelper.addAsConversion((NormalizedSimpleStack)nssLeftOutput, leftOutput.getAmount())) {
                handled = true;
            }
            ingredientHelper.resetHelper();
            ingredientHelper.put((NormalizedSimpleStack)nssInput, representation.getAmount());
            ingredientHelper.put((NormalizedSimpleStack)nssLeftOutput, -leftOutput.getAmount());
            if (!ingredientHelper.addAsConversion((NormalizedSimpleStack)nssRightOutput, rightOutput.getAmount())) continue;
            handled = true;
        }
        return handled;
    }
}

