/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync.chemical;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.pigment.IEmptyPigmentProvider;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.chemical.SyncableChemicalStack;
import mekanism.common.network.to_client.container.property.LongPropertyData;
import mekanism.common.network.to_client.container.property.PropertyData;
import mekanism.common.network.to_client.container.property.chemical.PigmentStackPropertyData;

public class SyncablePigmentStack
extends SyncableChemicalStack<Pigment, PigmentStack>
implements IEmptyPigmentProvider {
    public static SyncablePigmentStack create(IPigmentTank handler) {
        return SyncablePigmentStack.create(handler, false);
    }

    public static SyncablePigmentStack create(IPigmentTank handler, boolean isClient) {
        return SyncablePigmentStack.create(handler::getStack, isClient ? handler::setStackUnchecked : handler::setStack);
    }

    public static SyncablePigmentStack create(Supplier<@NonNull PigmentStack> getter, Consumer<@NonNull PigmentStack> setter) {
        return new SyncablePigmentStack(getter, setter);
    }

    private SyncablePigmentStack(Supplier<@NonNull PigmentStack> getter, Consumer<@NonNull PigmentStack> setter) {
        super(getter, setter);
    }

    @Override
    @Nonnull
    protected PigmentStack createStack(PigmentStack stored, long size) {
        return new PigmentStack(stored, size);
    }

    @Override
    public PropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        if (dirtyType == ISyncableData.DirtyType.SIZE) {
            return new LongPropertyData(property, ((PigmentStack)this.get()).getAmount());
        }
        return new PigmentStackPropertyData(property, (PigmentStack)this.get());
    }
}

