/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.block;

import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.inventory.container.item.PersonalChestItemContainer;
import mekanism.common.item.block.ItemBlockTooltip;
import mekanism.common.item.interfaces.IGuiItem;
import mekanism.common.item.interfaces.IItemSustainedInventory;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.ItemDeferredRegister;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class ItemBlockPersonalChest
extends ItemBlockTooltip<BlockTile.BlockTileModel<?, ?>>
implements IItemSustainedInventory,
ISecurityItem,
IGuiItem {
    public ItemBlockPersonalChest(BlockTile.BlockTileModel<?, ?> block) {
        super(block, true, ItemDeferredRegister.getMekBaseProperties().func_200917_a(1));
    }

    @Override
    public void addDetails(@Nonnull ItemStack stack, World world, @Nonnull List<ITextComponent> tooltip, boolean advanced) {
        SecurityUtils.addSecurityTooltip(stack, tooltip);
        tooltip.add((ITextComponent)MekanismLang.HAS_INVENTORY.translateColored(EnumColor.AQUA, EnumColor.GRAY, BooleanStateDisplay.YesNo.of(this.hasInventory(new Object[]{stack}))));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.getOwnerUUID(stack) == null) {
            if (!world.field_72995_K) {
                SecurityUtils.claimItem(player, stack);
            }
        } else if (SecurityUtils.canAccess(player, stack)) {
            if (!world.field_72995_K) {
                this.getContainerType().tryOpenGui((ServerPlayerEntity)player, hand, stack);
            }
        } else {
            if (!world.field_72995_K) {
                SecurityUtils.displayNoAccess(player);
            }
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext context) {
        ActionResultType result = this.func_195942_a(new BlockItemUseContext(context));
        PlayerEntity player = context.func_195999_j();
        return result.func_226246_a_() || player == null ? result : this.func_77659_a(context.func_195991_k(), player, context.func_221531_n()).func_188397_a();
    }

    protected boolean func_195944_a(@Nonnull BlockItemUseContext context, @Nonnull BlockState state) {
        PlayerEntity player = context.func_195999_j();
        return (player == null || player instanceof FakePlayer || player.func_225608_bj_()) && super.func_195944_a(context, state);
    }

    public ContainerTypeRegistryObject<PersonalChestItemContainer> getContainerType() {
        return MekanismContainerTypes.PERSONAL_CHEST_ITEM;
    }
}

