/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.client.render.armor.CustomArmor;
import mekanism.client.render.armor.JetpackArmor;
import mekanism.client.render.item.ISTERProvider;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.lib.attribute.AttributeCache;
import mekanism.common.lib.attribute.IAttributeRefresher;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemArmoredJetpack
extends ItemJetpack
implements IAttributeRefresher {
    private static final ArmoredJetpackMaterial ARMORED_JETPACK_MATERIAL = new ArmoredJetpackMaterial();
    private final AttributeCache attributeCache;

    public ItemArmoredJetpack(Item.Properties properties) {
        super(ARMORED_JETPACK_MATERIAL, properties.setISTER(ISTERProvider::armoredJetpack));
        this.attributeCache = new AttributeCache(this, MekanismConfig.gear.armoredJetpackArmor, MekanismConfig.gear.armoredJetpackToughness);
    }

    public int func_200881_e() {
        return this.func_200880_d().func_200902_b(this.func_185083_B_());
    }

    public float func_234657_f_() {
        return this.func_200880_d().func_200901_e();
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlotType slot, @Nonnull ItemStack stack) {
        return slot == this.func_185083_B_() ? this.attributeCache.getAttributes() : ImmutableMultimap.of();
    }

    @Override
    public void addToBuilder(ImmutableMultimap.Builder<Attribute, AttributeModifier> builder) {
        UUID modifier = field_185084_n[this.func_185083_B_().func_188454_b()];
        builder.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(modifier, "Armor modifier", (double)this.func_200881_e(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(modifier, "Armor toughness", (double)this.func_234657_f_(), AttributeModifier.Operation.ADDITION));
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public CustomArmor getGearModel() {
        return JetpackArmor.ARMORED_JETPACK;
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class ArmoredJetpackMaterial
    extends ItemJetpack.JetpackMaterial {
        private ArmoredJetpackMaterial() {
        }

        @Override
        public int func_200902_b(EquipmentSlotType slotType) {
            return slotType == EquipmentSlotType.CHEST ? MekanismConfig.gear.armoredJetpackArmor.get() : 0;
        }

        @Override
        public String func_200897_d() {
            return "mekanism:jetpack_armored";
        }

        @Override
        public float func_200901_e() {
            return MekanismConfig.gear.armoredJetpackToughness.get();
        }
    }
}

