/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mekanism.common.content.transporter.TransporterPathfinder;
import mekanism.common.util.WorldUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class SidedBlockPos {
    private final BlockPos pos;
    private final Direction side;

    public static SidedBlockPos get(TransporterPathfinder.Destination destination) {
        List<BlockPos> path = destination.getPath();
        BlockPos pos = path.get(0);
        Direction sideOfDest = WorldUtils.sideDifference(path.get(1), pos);
        return new SidedBlockPos(pos, sideOfDest);
    }

    @Nullable
    public static SidedBlockPos deserialize(CompoundNBT tag) {
        if (tag.func_150297_b("x", 3) && tag.func_150297_b("y", 3) && tag.func_150297_b("z", 3) && tag.func_150297_b("side", 3)) {
            BlockPos pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
            Direction side = Direction.func_82600_a((int)tag.func_74762_e("side"));
            return new SidedBlockPos(pos, side);
        }
        return null;
    }

    public SidedBlockPos(BlockPos pos, Direction side) {
        this.pos = pos.func_185334_h();
        this.side = side;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getSide() {
        return this.side;
    }

    public CompoundNBT serialize() {
        CompoundNBT target = new CompoundNBT();
        target.func_74768_a("x", this.pos.func_177958_n());
        target.func_74768_a("y", this.pos.func_177956_o());
        target.func_74768_a("z", this.pos.func_177952_p());
        target.func_74768_a("side", this.side.ordinal());
        return target;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SidedBlockPos that = (SidedBlockPos)o;
        return this.pos.equals((Object)that.pos) && this.side == that.side;
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.side);
    }
}

