/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.chunkloading;

import java.util.Comparator;
import javax.annotation.Nonnull;
import mekanism.common.lib.chunkloading.ChunkMultimap;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class ChunkManager
extends WorldSavedData {
    private static final String CHUNK_LIST_KEY = "chunks";
    private static final Logger LOGGER = LogManager.getLogger((String)"Mekanism ChunkManager");
    private static final String SAVEDATA_KEY = "mekanism_force_chunks";
    private static final TicketType<ChunkPos> INITIAL_LOAD_TICKET_TYPE = TicketType.func_223183_a((String)"mekanism:initial_chunkload", Comparator.comparingLong(ChunkPos::func_201841_a), (int)10);
    private ChunkMultimap chunks = new ChunkMultimap();

    private ChunkManager() {
        super(SAVEDATA_KEY);
    }

    public void func_76184_a(@Nonnull CompoundNBT nbt) {
        this.chunks = new ChunkMultimap();
        this.chunks.deserializeNBT(nbt.func_150295_c(CHUNK_LIST_KEY, 10));
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT compound) {
        compound.func_218657_a(CHUNK_LIST_KEY, (INBT)this.chunks.serializeNBT());
        return compound;
    }

    public static void worldLoad(ServerWorld world) {
        DimensionSavedDataManager savedDataManager = world.func_217481_x();
        ChunkManager savedData = (ChunkManager)savedDataManager.func_215753_b(ChunkManager::new, SAVEDATA_KEY);
        if (savedData != null) {
            int chunks = savedData.chunks.size();
            ResourceLocation dimension = world.func_234923_W_().func_240901_a_();
            if (chunks > 0) {
                LOGGER.info("Loading {} chunks for dimension {}", (Object)chunks, (Object)dimension);
                savedData.chunks.long2ObjectEntrySet().fastForEach(entry -> {
                    ChunkPos pos = new ChunkPos(entry.getLongKey());
                    world.func_72863_F().func_217228_a(INITIAL_LOAD_TICKET_TYPE, pos, 2, (Object)pos);
                });
                savedData.chunks.clear();
                savedData.func_76185_a();
                LOGGER.info("Loaded {} chunks for dimension {}. The {} data file for this dimension can now be safely removed as the data has been transferred to Forge's Chunk Manager.", (Object)chunks, (Object)dimension, (Object)SAVEDATA_KEY);
            } else {
                LOGGER.info("The {} data file for {} dimension can now be safely removed as it is no longer in use.", (Object)SAVEDATA_KEY, (Object)dimension);
            }
        }
    }
}

