/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.chunkloading;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.util.INBTSerializable;

public class ChunkMultimap
extends Long2ObjectOpenHashMap<Set<BlockPos>>
implements INBTSerializable<ListNBT> {
    private static final String ENTRIES_KEY = "entries";
    private static final String KEY_KEY = "key";

    public boolean add(ChunkPos key, BlockPos value) {
        return ((Set)this.computeIfAbsent(key.func_201841_a(), k -> new ObjectOpenHashSet())).add(value);
    }

    public void remove(ChunkPos key, BlockPos value) {
        Set chunkEntries = (Set)this.get(key.func_201841_a());
        if (chunkEntries != null) {
            chunkEntries.remove(value);
            if (chunkEntries.isEmpty()) {
                this.remove(key.func_201841_a());
            }
        }
    }

    public ListNBT serializeNBT() {
        ListNBT listOut = new ListNBT();
        this.long2ObjectEntrySet().fastForEach(entry -> {
            if (!((Set)entry.getValue()).isEmpty()) {
                CompoundNBT nbtEntry = new CompoundNBT();
                listOut.add((Object)nbtEntry);
                nbtEntry.func_74772_a(KEY_KEY, entry.getLongKey());
                ListNBT nbtEntryList = new ListNBT();
                nbtEntry.func_218657_a(ENTRIES_KEY, (INBT)nbtEntryList);
                for (BlockPos blockPos : (Set)entry.getValue()) {
                    nbtEntryList.add((Object)NBTUtil.func_186859_a((BlockPos)blockPos));
                }
            }
        });
        return listOut;
    }

    public void deserializeNBT(ListNBT entryList) {
        for (int i = 0; i < entryList.size(); ++i) {
            CompoundNBT entry = entryList.func_150305_b(i);
            long key = entry.func_74763_f(KEY_KEY);
            ListNBT blockPosList = entry.func_150295_c(ENTRIES_KEY, 10);
            ObjectOpenHashSet blockPosSet = new ObjectOpenHashSet();
            this.put(key, blockPosSet);
            for (int j = 0; j < blockPosList.size(); ++j) {
                blockPosSet.add(NBTUtil.func_186861_c((CompoundNBT)blockPosList.func_150305_b(j)));
            }
        }
    }
}

