/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.lib.collection.HashList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class FrequencyManager<FREQ extends Frequency> {
    public static final int MAX_FREQ_LENGTH = 16;
    private static boolean loaded;
    private static final Set<FrequencyManager<?>> managers;
    private final Map<Object, FREQ> frequencies = new LinkedHashMap<Object, FREQ>();
    @Nullable
    private FrequencyDataHandler dataHandler;
    private UUID ownerUUID;
    private final FrequencyType<FREQ> frequencyType;

    public FrequencyManager(FrequencyType<FREQ> frequencyType) {
        this.frequencyType = frequencyType;
        managers.add(this);
    }

    public FrequencyManager(FrequencyType<FREQ> frequencyType, UUID uuid) {
        this(frequencyType);
        this.ownerUUID = uuid;
    }

    public static void load() {
        if (!loaded) {
            loaded = true;
            FrequencyType.init();
            managers.forEach(FrequencyManager::createOrLoad);
        }
    }

    public static void tick() {
        if (!loaded) {
            FrequencyManager.load();
        }
        managers.forEach(FrequencyManager::tickSelf);
    }

    public static void reset() {
        for (FrequencyManager<?> manager : managers) {
            manager.frequencies.clear();
            manager.dataHandler = null;
        }
        loaded = false;
    }

    public FREQ update(TileEntity tile, FREQ freq) {
        FREQ storedFreq = this.getFrequency(((Frequency)freq).getKey());
        if (storedFreq != null) {
            ((Frequency)storedFreq).update(tile);
            this.markDirty();
            return storedFreq;
        }
        this.deactivate((Frequency)freq, tile);
        return null;
    }

    public boolean remove(Object key, UUID ownerUUID) {
        FREQ freq = this.getFrequency(key);
        if (freq != null && ((Frequency)freq).ownerMatches(ownerUUID)) {
            ((Frequency)freq).onRemove();
            this.frequencies.remove(key);
            this.markDirty();
            return true;
        }
        return false;
    }

    public void deactivate(Frequency freq, TileEntity tile) {
        if (freq != null) {
            freq.onDeactivate(tile);
            this.markDirty();
        }
    }

    public FREQ validateFrequency(TileEntity tile, FREQ freq) {
        FREQ storedFreq = this.getFrequency(((Frequency)freq).getKey());
        if (storedFreq == null) {
            ((Frequency)freq).setValid(true);
            this.addFrequency(freq);
            storedFreq = freq;
        }
        ((Frequency)storedFreq).update(tile);
        this.markDirty();
        return storedFreq;
    }

    public void createOrLoad() {
        if (this.dataHandler == null) {
            String name = this.getName();
            DimensionSavedDataManager savedData = ServerLifecycleHooks.getCurrentServer().func_241755_D_().func_217481_x();
            this.dataHandler = (FrequencyDataHandler)savedData.func_215752_a(() -> new FrequencyDataHandler(name), name);
            this.dataHandler.syncManager();
        }
    }

    public Collection<FREQ> getFrequencies() {
        return this.frequencies.values();
    }

    public FREQ getFrequency(Object key) {
        return (FREQ)((Frequency)this.frequencies.get(key));
    }

    public FREQ getOrCreateFrequency(Frequency.FrequencyIdentity identity, @Nullable UUID ownerUUID) {
        FREQ freq = this.getFrequency(identity.getKey());
        if (freq == null) {
            freq = this.frequencyType.create(identity.getKey(), ownerUUID);
            ((Frequency)freq).setPublic(identity.isPublic());
            this.addFrequency(freq);
        }
        return freq;
    }

    public void addFrequency(FREQ freq) {
        this.frequencies.put(((Frequency)freq).getKey(), freq);
        this.markDirty();
    }

    protected void markDirty() {
        if (this.dataHandler != null) {
            this.dataHandler.func_76185_a();
        }
    }

    public FrequencyType<FREQ> getType() {
        return this.frequencyType;
    }

    private void tickSelf() {
        this.getFrequencies().forEach(Frequency::tick);
    }

    public String getName() {
        return this.ownerUUID != null ? this.ownerUUID + "_" + this.frequencyType.getName() + "FrequencyHandler" : this.frequencyType.getName() + "FrequencyHandler";
    }

    static {
        managers = new ObjectOpenHashSet();
    }

    public class FrequencyDataHandler
    extends WorldSavedData {
        public List<FREQ> loadedFrequencies;
        public UUID loadedOwner;

        public FrequencyDataHandler(String tagName) {
            super(tagName);
        }

        public void syncManager() {
            if (this.loadedFrequencies != null) {
                this.loadedFrequencies.forEach(freq -> FrequencyManager.this.frequencies.put(freq.getKey(), freq));
                FrequencyManager.this.ownerUUID = this.loadedOwner;
            }
        }

        public void func_76184_a(@Nonnull CompoundNBT nbtTags) {
            NBTUtils.setUUIDIfPresent(nbtTags, "owner", uuid -> {
                this.loadedOwner = uuid;
            });
            ListNBT list = nbtTags.func_150295_c("freqList", 10);
            this.loadedFrequencies = new HashList();
            for (int i = 0; i < list.size(); ++i) {
                this.loadedFrequencies.add(FrequencyManager.this.frequencyType.create(list.func_150305_b(i)));
            }
        }

        @Nonnull
        public CompoundNBT func_189551_b(@Nonnull CompoundNBT nbtTags) {
            if (FrequencyManager.this.ownerUUID != null) {
                nbtTags.func_186854_a("owner", FrequencyManager.this.ownerUUID);
            }
            ListNBT list = new ListNBT();
            for (Frequency freq : FrequencyManager.this.getFrequencies()) {
                CompoundNBT compound = new CompoundNBT();
                freq.write(compound);
                list.add((Object)compound);
            }
            nbtTags.func_218657_a("freqList", (INBT)list);
            return nbtTags;
        }
    }
}

