/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableFrequency;
import mekanism.common.inventory.container.sync.list.SyncableFrequencyList;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class TileComponentFrequency
implements ITileComponent {
    private final TileEntityMekanism tile;
    private final Map<FrequencyType<?>, Frequency> heldFrequencies = new LinkedHashMap();
    private final Map<FrequencyType<?>, FrequencyTrackingData> supportedFrequencies = new LinkedHashMap();
    private final Map<FrequencyType<?>, List<? extends Frequency>> publicCache = new LinkedHashMap();
    private final Map<FrequencyType<?>, List<? extends Frequency>> privateCache = new LinkedHashMap();
    private boolean needsSave;
    private boolean needsNotify;

    public TileComponentFrequency(TileEntityMekanism tile) {
        this.tile = tile;
        tile.addComponent(this);
    }

    public boolean hasCustomFrequencies() {
        if (this.supportedFrequencies.containsKey(FrequencyType.SECURITY)) {
            return this.supportedFrequencies.size() > 1;
        }
        return !this.supportedFrequencies.isEmpty();
    }

    public void tickServer() {
        for (Map.Entry<FrequencyType<?>, Frequency> entry : this.heldFrequencies.entrySet()) {
            this.updateFrequency(entry.getKey(), entry.getValue());
        }
        if (this.needsNotify) {
            this.tile.invalidateCachedCapabilities();
            WorldUtils.notifyLoadedNeighborsOfTileChange(this.tile.func_145831_w(), this.tile.func_174877_v());
            this.needsNotify = false;
        }
        if (this.needsSave) {
            this.tile.markDirty(false);
            this.needsSave = false;
        }
    }

    public void track(FrequencyType<?> type, boolean needsSync, boolean needsListCache, boolean notifyNeighbors) {
        this.supportedFrequencies.put(type, new FrequencyTrackingData(needsSync, needsListCache, notifyNeighbors));
    }

    public <FREQ extends Frequency> FREQ getFrequency(FrequencyType<FREQ> type) {
        return (FREQ)this.heldFrequencies.get(type);
    }

    public void setFrequency(FrequencyType<?> type, Frequency freq) {
        this.heldFrequencies.put(type, freq);
    }

    public <FREQ extends Frequency> void unsetFrequency(FrequencyType<FREQ> type) {
        if (this.heldFrequencies.containsKey(type)) {
            this.deactivate(type);
            this.heldFrequencies.remove(type);
            this.setNeedsNotify(type);
        }
    }

    public <FREQ extends Frequency> List<FREQ> getPublicCache(FrequencyType<FREQ> type) {
        return this.getCache(this.publicCache, type);
    }

    public <FREQ extends Frequency> List<FREQ> getPrivateCache(FrequencyType<FREQ> type) {
        return this.getCache(this.privateCache, type);
    }

    private <FREQ extends Frequency> List<FREQ> getCache(Map<FrequencyType<?>, List<? extends Frequency>> cache, FrequencyType<FREQ> type) {
        return cache.computeIfAbsent(type, t -> new ArrayList());
    }

    public <FREQ extends Frequency> void setFrequencyFromData(FrequencyType<FREQ> type, Frequency.FrequencyIdentity data, UUID player) {
        if (player != null) {
            FREQ oldFrequency = this.getFrequency(type);
            FrequencyManager<FREQ> manager = type.getManager(data, player);
            FREQ freq = manager.getOrCreateFrequency(data, player);
            if (oldFrequency == null || !((Frequency)oldFrequency).equals(freq)) {
                manager.deactivate((Frequency)oldFrequency, this.tile);
                ((Frequency)freq).update(this.tile);
                this.setFrequency(type, (Frequency)freq);
                this.setNeedsNotify(type);
            }
        }
    }

    public void removeFrequencyFromData(FrequencyType<?> type, Frequency.FrequencyIdentity data, UUID player) {
        FrequencyManager<?> manager = type.getManager(data, player);
        if (manager != null && manager.remove(data.getKey(), player)) {
            this.setNeedsNotify(type);
        }
    }

    private <FREQ extends Frequency> void updateFrequency(FrequencyType<FREQ> type, FREQ frequency) {
        FREQ lastFreq = frequency;
        FrequencyManager<FREQ> manager = type.getFrequencyManager(frequency);
        if (manager != null) {
            if (!frequency.isValid()) {
                frequency = manager.validateFrequency(this.tile, frequency);
                this.setNeedsNotify(type);
            }
            if (frequency != null && (frequency = manager.update(this.tile, frequency)) == null) {
                this.setNeedsNotify(type);
            }
        } else {
            frequency = null;
            if (lastFreq != null) {
                this.setNeedsNotify(type);
            }
        }
        if (frequency != lastFreq) {
            this.setFrequency(type, frequency);
        }
    }

    private void setNeedsNotify(FrequencyType<?> type) {
        if (this.supportedFrequencies.get(type).notifyNeighbors) {
            this.needsNotify = true;
        }
        this.needsSave = true;
    }

    private void unload() {
        if (!this.tile.isRemote()) {
            this.heldFrequencies.forEach((key, value) -> this.deactivate((FrequencyType)key));
        }
    }

    private <FREQ extends Frequency> void deactivate(FrequencyType<FREQ> type) {
        FrequencyManager<FREQ> manager;
        FREQ freq = this.getFrequency(type);
        if (freq != null && (manager = type.getFrequencyManager(freq)) != null) {
            manager.deactivate((Frequency)freq, this.tile);
        }
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        CompoundNBT frequencyNBT = nbtTags.func_150297_b("componentFrequency", 10) ? nbtTags.func_74775_l("componentFrequency") : nbtTags;
        for (FrequencyType<?> type : this.supportedFrequencies.keySet()) {
            if (!frequencyNBT.func_150297_b(type.getName(), 10)) continue;
            Object frequency = type.create(frequencyNBT.func_74775_l(type.getName()));
            ((Frequency)frequency).setValid(false);
            this.heldFrequencies.put(type, (Frequency)frequency);
        }
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        CompoundNBT frequencyNBT = new CompoundNBT();
        for (Frequency frequency : this.heldFrequencies.values()) {
            if (frequency == null) continue;
            CompoundNBT frequencyTag = new CompoundNBT();
            frequency.writeComponentData(frequencyTag);
            frequencyNBT.func_218657_a(frequency.getType().getName(), (INBT)frequencyTag);
        }
        nbtTags.func_218657_a("componentFrequency", (INBT)frequencyNBT);
    }

    public void readConfiguredFrequencies(PlayerEntity player, CompoundNBT data) {
        if (this.hasCustomFrequencies() && data.func_150297_b("componentFrequency", 10)) {
            CompoundNBT frequencyNBT = data.func_74775_l("componentFrequency");
            for (FrequencyType<?> type : this.supportedFrequencies.keySet()) {
                Frequency.FrequencyIdentity identity;
                CompoundNBT frequencyData;
                if (type == FrequencyType.SECURITY) continue;
                if (frequencyNBT.func_150297_b(type.getName(), 10) && (frequencyData = frequencyNBT.func_74775_l(type.getName())).func_186855_b("owner") && (identity = Frequency.FrequencyIdentity.load(type, frequencyData)) != null) {
                    UUID owner = frequencyData.func_186857_a("owner");
                    if (!identity.isPublic() && !owner.equals(player.func_110124_au())) continue;
                    this.setFrequencyFromData(type, identity, owner);
                    continue;
                }
                this.unsetFrequency(type);
            }
        }
    }

    public void writeConfiguredFrequencies(CompoundNBT data) {
        CompoundNBT frequencyNBT = new CompoundNBT();
        for (Frequency frequency : this.heldFrequencies.values()) {
            if (frequency == null || frequency.getType() == FrequencyType.SECURITY) continue;
            frequencyNBT.func_218657_a(frequency.getType().getName(), (INBT)frequency.serializeIdentityWithOwner());
        }
        if (!frequencyNBT.isEmpty()) {
            data.func_218657_a("componentFrequency", (INBT)frequencyNBT);
        }
    }

    @Override
    public void invalidate() {
        this.unload();
    }

    @Override
    public void onChunkUnload() {
        this.unload();
    }

    @Override
    public void trackForMainContainer(MekanismContainer container) {
        for (Map.Entry<FrequencyType<?>, FrequencyTrackingData> entry : this.supportedFrequencies.entrySet()) {
            if (entry.getValue().needsContainerSync) {
                container.track(SyncableFrequency.create(() -> this.heldFrequencies.get(entry.getKey()), value -> this.heldFrequencies.put((FrequencyType<?>)entry.getKey(), (Frequency)value)));
            }
            if (!entry.getValue().needsListCache) continue;
            this.track(container, entry.getKey());
        }
    }

    private <FREQ extends Frequency> void track(MekanismContainer container, FrequencyType<FREQ> type) {
        if (container.isRemote()) {
            container.track(SyncableFrequencyList.create(() -> this.getPublicCache(type), value -> this.publicCache.put(type, (List<Frequency>)value)));
            container.track(SyncableFrequencyList.create(() -> this.getPrivateCache(type), value -> this.privateCache.put(type, (List<Frequency>)value)));
        } else {
            container.track(SyncableFrequencyList.create(() -> type.getManagerWrapper().getPublicManager().getFrequencies(), value -> this.publicCache.put(type, (List<Frequency>)value)));
            container.track(SyncableFrequencyList.create(() -> type.getManagerWrapper().getPrivateManager(container.getPlayerUUID()).getFrequencies(), value -> this.privateCache.put(type, (List<Frequency>)value)));
        }
    }

    private static class FrequencyTrackingData {
        private final boolean needsContainerSync;
        private final boolean needsListCache;
        private final boolean notifyNeighbors;

        public FrequencyTrackingData(boolean needsContainerSync, boolean needsListCache, boolean notifyNeighbors) {
            this.needsContainerSync = needsContainerSync;
            this.needsListCache = needsListCache;
            this.notifyNeighbors = notifyNeighbors;
        }
    }
}

