/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import java.util.Collection;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public interface IValveHandler {
    default public void writeValves(CompoundNBT updateTag) {
        ListNBT valves = new ListNBT();
        for (ValveData valveData : this.getValveData()) {
            if (valveData.activeTicks <= 0) continue;
            CompoundNBT valveNBT = new CompoundNBT();
            valveNBT.func_218657_a("position", (INBT)NBTUtil.func_186859_a((BlockPos)valveData.location));
            valveNBT.func_74768_a("side", valveData.side.ordinal());
            valves.add((Object)valveNBT);
        }
        updateTag.func_218657_a("valve", (INBT)valves);
    }

    default public void readValves(CompoundNBT updateTag) {
        this.getValveData().clear();
        if (updateTag.func_150297_b("valve", 9)) {
            ListNBT valves = updateTag.func_150295_c("valve", 10);
            for (int i = 0; i < valves.size(); ++i) {
                CompoundNBT valveNBT = valves.func_150305_b(i);
                ValveData data = new ValveData();
                NBTUtils.setBlockPosIfPresent(valveNBT, "position", pos -> {
                    data.location = pos;
                });
                data.side = Direction.func_82600_a((int)valveNBT.func_74762_e("side"));
                this.getValveData().add(data);
            }
        }
    }

    default public void triggerValveTransfer(IMultiblock<?> multiblock) {
        if (((MultiblockData)multiblock.getMultiblock()).isFormed()) {
            for (ValveData data : this.getValveData()) {
                if (!multiblock.getTilePos().equals((Object)data.location)) continue;
                data.onTransfer();
                break;
            }
        }
    }

    public Collection<ValveData> getValveData();

    public static class ValveData {
        public Direction side;
        public BlockPos location;
        public boolean prevActive;
        public int activeTicks;

        public void onTransfer() {
            this.activeTicks = 30;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.side.ordinal();
            code = 31 * code + this.location.hashCode();
            return code;
        }

        public boolean equals(Object obj) {
            return obj instanceof ValveData && ((ValveData)obj).side == this.side && ((ValveData)obj).location.equals((Object)this.location);
        }
    }
}

