/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.Optional;
import java.util.function.Function;
import mekanism.api.Range3D;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public abstract class BasePacketHandler {
    private int index = 0;

    protected static SimpleChannel createChannel(ResourceLocation name) {
        return NetworkRegistry.ChannelBuilder.named((ResourceLocation)name).clientAcceptedVersions(BasePacketHandler.getProtocolVersion()::equals).serverAcceptedVersions(BasePacketHandler.getProtocolVersion()::equals).networkProtocolVersion(BasePacketHandler::getProtocolVersion).simpleChannel();
    }

    private static String getProtocolVersion() {
        return Mekanism.instance == null ? "999.999.999" : Mekanism.instance.versionNumber.toString();
    }

    public static String readString(PacketBuffer buffer) {
        return buffer.func_150789_c(Short.MAX_VALUE);
    }

    public static Vector3d readVector3d(PacketBuffer buffer) {
        return new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public static void writeVector3d(PacketBuffer buffer, Vector3d vector) {
        buffer.writeDouble(vector.func_82615_a());
        buffer.writeDouble(vector.func_82617_b());
        buffer.writeDouble(vector.func_82616_c());
    }

    public static void log(String logFormat, Object ... params) {
        if (MekanismConfig.general.logPackets.get()) {
            Mekanism.logger.info(logFormat, params);
        }
    }

    protected abstract SimpleChannel getChannel();

    public abstract void initialize();

    protected <MSG extends IMekanismPacket> void registerClientToServer(Class<MSG> type, Function<PacketBuffer, MSG> decoder) {
        this.registerMessage(type, decoder, NetworkDirection.PLAY_TO_SERVER);
    }

    protected <MSG extends IMekanismPacket> void registerServerToClient(Class<MSG> type, Function<PacketBuffer, MSG> decoder) {
        this.registerMessage(type, decoder, NetworkDirection.PLAY_TO_CLIENT);
    }

    private <MSG extends IMekanismPacket> void registerMessage(Class<MSG> type, Function<PacketBuffer, MSG> decoder, NetworkDirection networkDirection) {
        this.getChannel().registerMessage(this.index++, type, IMekanismPacket::encode, decoder, IMekanismPacket::handle, Optional.of(networkDirection));
    }

    public <MSG> void sendTo(MSG message, ServerPlayerEntity player) {
        if (!(player instanceof FakePlayer)) {
            this.getChannel().sendTo(message, player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public <MSG> void sendToAll(MSG message) {
        this.getChannel().send(PacketDistributor.ALL.noArg(), message);
    }

    public <MSG> void sendToAllIfLoaded(MSG message) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            this.sendToAll(message);
        }
    }

    public <MSG> void sendToDimension(MSG message, RegistryKey<World> dimension) {
        this.getChannel().send(PacketDistributor.DIMENSION.with(() -> dimension), message);
    }

    public <MSG> void sendToServer(MSG message) {
        this.getChannel().sendToServer(message);
    }

    public <MSG> void sendToAllTracking(MSG message, Entity entity) {
        this.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), message);
    }

    public <MSG> void sendToAllTrackingAndSelf(MSG message, Entity entity) {
        this.getChannel().send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), message);
    }

    public <MSG> void sendToAllTracking(MSG message, TileEntity tile) {
        this.sendToAllTracking(message, tile.func_145831_w(), tile.func_174877_v());
    }

    public <MSG> void sendToAllTracking(MSG message, World world, BlockPos pos) {
        if (world instanceof ServerWorld) {
            ((ServerWorld)world).func_72863_F().field_217237_a.func_219097_a(new ChunkPos(pos), false).forEach(p -> this.sendTo(message, (ServerPlayerEntity)p));
        } else {
            this.getChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4)), message);
        }
    }

    public <MSG> void sendToReceivers(MSG message, DynamicBufferedNetwork<?, ?, ?, ?> network) {
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                Range3D range = network.getPacketRange();
                PlayerList playerList = server.func_184103_al();
                int radius = playerList.func_72395_o() * 16;
                for (ServerPlayerEntity player : playerList.func_181057_v()) {
                    if (range.dimension != player.func_71121_q().func_234923_W_()) continue;
                    BlockPos playerPosition = player.func_233580_cy_();
                    int playerX = playerPosition.func_177958_n();
                    int playerZ = playerPosition.func_177952_p();
                    if (!((double)(playerX + radius) + 1.99999 > (double)range.xMin) || !((double)range.xMax + 0.99999 > (double)(playerX - radius)) || !((double)(playerZ + radius) + 1.99999 > (double)range.zMin) || !((double)range.zMax + 0.99999 > (double)(playerZ - radius))) continue;
                    this.sendTo(message, player);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

