/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.ContainerProvider;
import mekanism.common.inventory.container.ModuleTweakerContainer;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class PacketOpenGui
implements IMekanismPacket {
    private final GuiType type;

    public PacketOpenGui(GuiType type) {
        this.type = type;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player != null && this.type.shouldOpenForPlayer.test(player)) {
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)((INamedContainerProvider)this.type.containerSupplier.get()));
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.type);
    }

    public static PacketOpenGui decode(PacketBuffer buffer) {
        return new PacketOpenGui((GuiType)buffer.func_179257_a(GuiType.class));
    }

    public static enum GuiType {
        MODULE_TWEAKER(() -> new ContainerProvider(MekanismLang.MODULE_TWEAKER, (id, inv, player) -> new ModuleTweakerContainer(id, inv)), ModuleTweakerContainer::hasTweakableItem);

        private final Supplier<INamedContainerProvider> containerSupplier;
        private final Predicate<PlayerEntity> shouldOpenForPlayer;

        private GuiType(Supplier<INamedContainerProvider> containerSupplier) {
            this(containerSupplier, player -> true);
        }

        private GuiType(Supplier<INamedContainerProvider> containerSupplier, Predicate<PlayerEntity> shouldOpenForPlayer) {
            this.containerSupplier = containerSupplier;
            this.shouldOpenForPlayer = shouldOpenForPlayer;
        }
    }
}

