/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.inventory.IgnoredIInventory;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.ChemicalInfuserRecipe;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.ItemStackToGasRecipe;
import mekanism.api.recipes.ItemStackToInfuseTypeRecipe;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.ItemStackToPigmentRecipe;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.PaintingRecipe;
import mekanism.api.recipes.PigmentMixingRecipe;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.chemical.ChemicalToChemicalRecipe;
import mekanism.api.recipes.chemical.FluidChemicalToChemicalRecipe;
import mekanism.api.recipes.chemical.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.chemical.ItemStackToChemicalRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.recipe.impl.SmeltingIRecipe;
import mekanism.common.recipe.lookup.cache.ChemicalCrystallizerInputRecipeCache;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.lookup.cache.RotaryInputRecipeCache;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.IForgeRegistry;

public class MekanismRecipeType<RECIPE_TYPE extends MekanismRecipe, INPUT_CACHE extends IInputRecipeCache>
implements IRecipeType<RECIPE_TYPE> {
    private static final List<MekanismRecipeType<?, ?>> types = new ArrayList();
    public static final MekanismRecipeType<ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>> CRUSHING = MekanismRecipeType.create("crushing", recipeType -> new InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>((MekanismRecipeType<ItemStackToItemStackRecipe, ?>)recipeType, ItemStackToItemStackRecipe::getInput));
    public static final MekanismRecipeType<ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>> ENRICHING = MekanismRecipeType.create("enriching", recipeType -> new InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>((MekanismRecipeType<ItemStackToItemStackRecipe, ?>)recipeType, ItemStackToItemStackRecipe::getInput));
    public static final MekanismRecipeType<ItemStackToItemStackRecipe, InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>> SMELTING = MekanismRecipeType.create("smelting", recipeType -> new InputRecipeCache.SingleItem<ItemStackToItemStackRecipe>((MekanismRecipeType<ItemStackToItemStackRecipe, ?>)recipeType, ItemStackToItemStackRecipe::getInput));
    public static final MekanismRecipeType<ChemicalInfuserRecipe, InputRecipeCache.EitherSideChemical<Gas, GasStack, ChemicalInfuserRecipe>> CHEMICAL_INFUSING = MekanismRecipeType.create("chemical_infusing", InputRecipeCache.EitherSideChemical::new);
    public static final MekanismRecipeType<CombinerRecipe, InputRecipeCache.DoubleItem<CombinerRecipe>> COMBINING = MekanismRecipeType.create("combining", recipeType -> new InputRecipeCache.DoubleItem<CombinerRecipe>((MekanismRecipeType<CombinerRecipe, ?>)recipeType, CombinerRecipe::getMainInput, CombinerRecipe::getExtraInput));
    public static final MekanismRecipeType<ElectrolysisRecipe, InputRecipeCache.SingleFluid<ElectrolysisRecipe>> SEPARATING = MekanismRecipeType.create("separating", recipeType -> new InputRecipeCache.SingleFluid<ElectrolysisRecipe>((MekanismRecipeType<ElectrolysisRecipe, ?>)recipeType, ElectrolysisRecipe::getInput));
    public static final MekanismRecipeType<FluidSlurryToSlurryRecipe, InputRecipeCache.FluidChemical<Slurry, SlurryStack, FluidSlurryToSlurryRecipe>> WASHING = MekanismRecipeType.create("washing", recipeType -> new InputRecipeCache.FluidChemical((MekanismRecipeType<FluidSlurryToSlurryRecipe, ?>)recipeType, FluidChemicalToChemicalRecipe::getFluidInput, FluidChemicalToChemicalRecipe::getChemicalInput));
    public static final MekanismRecipeType<FluidToFluidRecipe, InputRecipeCache.SingleFluid<FluidToFluidRecipe>> EVAPORATING = MekanismRecipeType.create("evaporating", recipeType -> new InputRecipeCache.SingleFluid<FluidToFluidRecipe>((MekanismRecipeType<FluidToFluidRecipe, ?>)recipeType, FluidToFluidRecipe::getInput));
    public static final MekanismRecipeType<GasToGasRecipe, InputRecipeCache.SingleChemical<Gas, GasStack, GasToGasRecipe>> ACTIVATING = MekanismRecipeType.create("activating", recipeType -> new InputRecipeCache.SingleChemical((MekanismRecipeType<GasToGasRecipe, ?>)recipeType, ChemicalToChemicalRecipe::getInput));
    public static final MekanismRecipeType<GasToGasRecipe, InputRecipeCache.SingleChemical<Gas, GasStack, GasToGasRecipe>> CENTRIFUGING = MekanismRecipeType.create("centrifuging", recipeType -> new InputRecipeCache.SingleChemical((MekanismRecipeType<GasToGasRecipe, ?>)recipeType, ChemicalToChemicalRecipe::getInput));
    public static final MekanismRecipeType<ChemicalCrystallizerRecipe, ChemicalCrystallizerInputRecipeCache> CRYSTALLIZING = MekanismRecipeType.create("crystallizing", ChemicalCrystallizerInputRecipeCache::new);
    public static final MekanismRecipeType<ChemicalDissolutionRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ChemicalDissolutionRecipe>> DISSOLUTION = MekanismRecipeType.create("dissolution", recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<ChemicalDissolutionRecipe, ?>)recipeType, ChemicalDissolutionRecipe::getItemInput, ChemicalDissolutionRecipe::getGasInput));
    public static final MekanismRecipeType<ItemStackGasToItemStackRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ItemStackGasToItemStackRecipe>> COMPRESSING = MekanismRecipeType.create("compressing", recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<ItemStackGasToItemStackRecipe, ?>)recipeType, ItemStackChemicalToItemStackRecipe::getItemInput, ItemStackChemicalToItemStackRecipe::getChemicalInput));
    public static final MekanismRecipeType<ItemStackGasToItemStackRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ItemStackGasToItemStackRecipe>> PURIFYING = MekanismRecipeType.create("purifying", recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<ItemStackGasToItemStackRecipe, ?>)recipeType, ItemStackChemicalToItemStackRecipe::getItemInput, ItemStackChemicalToItemStackRecipe::getChemicalInput));
    public static final MekanismRecipeType<ItemStackGasToItemStackRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, ItemStackGasToItemStackRecipe>> INJECTING = MekanismRecipeType.create("injecting", recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<ItemStackGasToItemStackRecipe, ?>)recipeType, ItemStackChemicalToItemStackRecipe::getItemInput, ItemStackChemicalToItemStackRecipe::getChemicalInput));
    public static final MekanismRecipeType<NucleosynthesizingRecipe, InputRecipeCache.ItemChemical<Gas, GasStack, NucleosynthesizingRecipe>> NUCLEOSYNTHESIZING = MekanismRecipeType.create("nucleosynthesizing", recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<NucleosynthesizingRecipe, ?>)recipeType, ItemStackChemicalToItemStackRecipe::getItemInput, ItemStackChemicalToItemStackRecipe::getChemicalInput));
    public static final MekanismRecipeType<ItemStackToEnergyRecipe, InputRecipeCache.SingleItem<ItemStackToEnergyRecipe>> ENERGY_CONVERSION = MekanismRecipeType.create("energy_conversion", recipeType -> new InputRecipeCache.SingleItem<ItemStackToEnergyRecipe>((MekanismRecipeType<ItemStackToEnergyRecipe, ?>)recipeType, ItemStackToEnergyRecipe::getInput));
    public static final MekanismRecipeType<ItemStackToGasRecipe, InputRecipeCache.SingleItem<ItemStackToGasRecipe>> GAS_CONVERSION = MekanismRecipeType.create("gas_conversion", recipeType -> new InputRecipeCache.SingleItem<ItemStackToGasRecipe>((MekanismRecipeType<ItemStackToGasRecipe, ?>)recipeType, ItemStackToChemicalRecipe::getInput));
    public static final MekanismRecipeType<ItemStackToGasRecipe, InputRecipeCache.SingleItem<ItemStackToGasRecipe>> OXIDIZING = MekanismRecipeType.create("oxidizing", recipeType -> new InputRecipeCache.SingleItem<ItemStackToGasRecipe>((MekanismRecipeType<ItemStackToGasRecipe, ?>)recipeType, ItemStackToChemicalRecipe::getInput));
    public static final MekanismRecipeType<ItemStackToInfuseTypeRecipe, InputRecipeCache.SingleItem<ItemStackToInfuseTypeRecipe>> INFUSION_CONVERSION = MekanismRecipeType.create("infusion_conversion", recipeType -> new InputRecipeCache.SingleItem<ItemStackToInfuseTypeRecipe>((MekanismRecipeType<ItemStackToInfuseTypeRecipe, ?>)recipeType, ItemStackToChemicalRecipe::getInput));
    public static final MekanismRecipeType<ItemStackToPigmentRecipe, InputRecipeCache.SingleItem<ItemStackToPigmentRecipe>> PIGMENT_EXTRACTING = MekanismRecipeType.create("pigment_extracting", recipeType -> new InputRecipeCache.SingleItem<ItemStackToPigmentRecipe>((MekanismRecipeType<ItemStackToPigmentRecipe, ?>)recipeType, ItemStackToChemicalRecipe::getInput));
    public static final MekanismRecipeType<PigmentMixingRecipe, InputRecipeCache.EitherSideChemical<Pigment, PigmentStack, PigmentMixingRecipe>> PIGMENT_MIXING = MekanismRecipeType.create("pigment_mixing", InputRecipeCache.EitherSideChemical::new);
    public static final MekanismRecipeType<MetallurgicInfuserRecipe, InputRecipeCache.ItemChemical<InfuseType, InfusionStack, MetallurgicInfuserRecipe>> METALLURGIC_INFUSING = MekanismRecipeType.create("metallurgic_infusing", recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<MetallurgicInfuserRecipe, ?>)recipeType, ItemStackChemicalToItemStackRecipe::getItemInput, ItemStackChemicalToItemStackRecipe::getChemicalInput));
    public static final MekanismRecipeType<PaintingRecipe, InputRecipeCache.ItemChemical<Pigment, PigmentStack, PaintingRecipe>> PAINTING = MekanismRecipeType.create("painting", recipeType -> new InputRecipeCache.ItemChemical((MekanismRecipeType<PaintingRecipe, ?>)recipeType, ItemStackChemicalToItemStackRecipe::getItemInput, ItemStackChemicalToItemStackRecipe::getChemicalInput));
    public static final MekanismRecipeType<PressurizedReactionRecipe, InputRecipeCache.ItemFluidChemical<Gas, GasStack, PressurizedReactionRecipe>> REACTION = MekanismRecipeType.create("reaction", recipeType -> new InputRecipeCache.ItemFluidChemical((MekanismRecipeType<PressurizedReactionRecipe, ?>)recipeType, PressurizedReactionRecipe::getInputSolid, PressurizedReactionRecipe::getInputFluid, PressurizedReactionRecipe::getInputGas));
    public static final MekanismRecipeType<RotaryRecipe, RotaryInputRecipeCache> ROTARY = MekanismRecipeType.create("rotary", RotaryInputRecipeCache::new);
    public static final MekanismRecipeType<SawmillRecipe, InputRecipeCache.SingleItem<SawmillRecipe>> SAWING = MekanismRecipeType.create("sawing", recipeType -> new InputRecipeCache.SingleItem<SawmillRecipe>((MekanismRecipeType<SawmillRecipe, ?>)recipeType, SawmillRecipe::getInput));
    private List<RECIPE_TYPE> cachedRecipes = Collections.emptyList();
    private final ResourceLocation registryName;
    private final INPUT_CACHE inputCache;

    private static <RECIPE_TYPE extends MekanismRecipe, INPUT_CACHE extends IInputRecipeCache> MekanismRecipeType<RECIPE_TYPE, INPUT_CACHE> create(String name, Function<MekanismRecipeType<RECIPE_TYPE, INPUT_CACHE>, INPUT_CACHE> inputCacheCreator) {
        MekanismRecipeType<RECIPE_TYPE, INPUT_CACHE> type = new MekanismRecipeType<RECIPE_TYPE, INPUT_CACHE>(name, inputCacheCreator);
        types.add(type);
        return type;
    }

    public static void registerRecipeTypes(IForgeRegistry<IRecipeSerializer<?>> registry) {
        types.forEach(type -> {
            MekanismRecipeType cfr_ignored_0 = (MekanismRecipeType)Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)type.registryName, (Object)type);
        });
    }

    public static void clearCache() {
        types.forEach(MekanismRecipeType::clearCaches);
    }

    private MekanismRecipeType(String name, Function<MekanismRecipeType<RECIPE_TYPE, INPUT_CACHE>, INPUT_CACHE> inputCacheCreator) {
        this.registryName = Mekanism.rl(name);
        this.inputCache = (IInputRecipeCache)inputCacheCreator.apply(this);
    }

    public String toString() {
        return this.registryName.toString();
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    private void clearCaches() {
        this.cachedRecipes.clear();
        this.inputCache.clear();
    }

    public INPUT_CACHE getInputCache() {
        return this.inputCache;
    }

    @Nonnull
    public List<RECIPE_TYPE> getRecipes(@Nullable World world) {
        if (world == null && (world = (World)DistExecutor.safeRunForDist(() -> MekanismClient::tryGetClientWorld, () -> (DistExecutor.SafeSupplier & Serializable)() -> ServerLifecycleHooks.getCurrentServer().func_241755_D_())) == null) {
            return Collections.emptyList();
        }
        if (this.cachedRecipes.isEmpty()) {
            RecipeManager recipeManager = world.func_199532_z();
            ArrayList<SmeltingIRecipe> recipes = recipeManager.func_215370_b((IRecipeType)this, (IInventory)IgnoredIInventory.INSTANCE, world);
            if (this == SMELTING) {
                Map smeltingRecipes = recipeManager.func_215366_a(IRecipeType.field_222150_b);
                recipes = new ArrayList<SmeltingIRecipe>(recipes);
                for (Map.Entry entry : smeltingRecipes.entrySet()) {
                    ItemStackIngredient input;
                    NonNullList ingredients;
                    int ingredientCount;
                    IRecipe smeltingRecipe = (IRecipe)entry.getValue();
                    ItemStack recipeOutput = smeltingRecipe.func_77571_b();
                    if (smeltingRecipe.func_192399_d() || recipeOutput.func_190926_b() || (ingredientCount = (ingredients = smeltingRecipe.func_192400_c()).size()) == 0) continue;
                    if (ingredientCount == 1) {
                        input = ItemStackIngredient.from((Ingredient)ingredients.get(0));
                    } else {
                        ItemStackIngredient[] itemIngredients = new ItemStackIngredient[ingredientCount];
                        for (int i = 0; i < ingredientCount; ++i) {
                            itemIngredients[i] = ItemStackIngredient.from((Ingredient)ingredients.get(i));
                        }
                        input = ItemStackIngredient.createMulti(itemIngredients);
                    }
                    recipes.add(new SmeltingIRecipe((ResourceLocation)entry.getKey(), input, recipeOutput));
                }
            }
            this.cachedRecipes = recipes;
        }
        return this.cachedRecipes;
    }

    public Stream<RECIPE_TYPE> stream(@Nullable World world) {
        return this.getRecipes(world).stream();
    }

    @Nullable
    public RECIPE_TYPE findFirst(@Nullable World world, Predicate<RECIPE_TYPE> matchCriteria) {
        return (RECIPE_TYPE)((MekanismRecipe)this.stream(world).filter(matchCriteria).findFirst().orElse(null));
    }

    public boolean contains(@Nullable World world, Predicate<RECIPE_TYPE> matchCriteria) {
        return this.stream(world).anyMatch(matchCriteria);
    }
}

