/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache.type;

import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.chemical.ChemicalStackIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.common.recipe.lookup.cache.type.BaseInputCache;

public class ChemicalInputCache<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends MekanismRecipe>
extends BaseInputCache<CHEMICAL, STACK, IChemicalStackIngredient<CHEMICAL, STACK>, RECIPE> {
    @Override
    public boolean mapInputs(RECIPE recipe, IChemicalStackIngredient<CHEMICAL, STACK> inputIngredient) {
        if (inputIngredient instanceof ChemicalStackIngredient.SingleIngredient) {
            Object input = ((ChemicalStackIngredient.SingleIngredient)inputIngredient).getInputRaw();
            this.addInputCache(input, recipe);
        } else if (inputIngredient instanceof ChemicalStackIngredient.TaggedIngredient) {
            for (Chemical input : ((ChemicalStackIngredient.TaggedIngredient)inputIngredient).getRawInput()) {
                this.addInputCache(input, recipe);
            }
        } else {
            if (inputIngredient instanceof ChemicalStackIngredient.MultiIngredient) {
                return ((ChemicalStackIngredient.MultiIngredient)inputIngredient).forEachIngredient(ingredient -> this.mapInputs(recipe, (IChemicalStackIngredient<CHEMICAL, STACK>)ingredient));
            }
            return true;
        }
        return false;
    }

    @Override
    protected CHEMICAL createKey(STACK stack) {
        return ((ChemicalStack)stack).getType();
    }

    @Override
    public boolean isEmpty(STACK input) {
        return ((ChemicalStack)input).isEmpty();
    }
}

