/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.providers.IFluidProvider;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@ParametersAreNonnullByDefault
public class FluidRegistryObject<STILL extends Fluid, FLOWING extends Fluid, BLOCK extends FlowingFluidBlock, BUCKET extends BucketItem>
implements IFluidProvider {
    private RegistryObject<STILL> stillRO;
    private RegistryObject<FLOWING> flowingRO;
    private RegistryObject<BLOCK> blockRO;
    private RegistryObject<BUCKET> bucketRO;

    public FluidRegistryObject(String modid, String name) {
        this.stillRO = RegistryObject.of((ResourceLocation)new ResourceLocation(modid, name), (IForgeRegistry)ForgeRegistries.FLUIDS);
        this.flowingRO = RegistryObject.of((ResourceLocation)new ResourceLocation(modid, "flowing_" + name), (IForgeRegistry)ForgeRegistries.FLUIDS);
        this.blockRO = RegistryObject.of((ResourceLocation)new ResourceLocation(modid, name), (IForgeRegistry)ForgeRegistries.BLOCKS);
        this.bucketRO = RegistryObject.of((ResourceLocation)new ResourceLocation(modid, name + "_bucket"), (IForgeRegistry)ForgeRegistries.ITEMS);
    }

    public STILL getStillFluid() {
        return (STILL)((Fluid)this.stillRO.get());
    }

    public FLOWING getFlowingFluid() {
        return (FLOWING)((Fluid)this.flowingRO.get());
    }

    public BLOCK getBlock() {
        return (BLOCK)((FlowingFluidBlock)this.blockRO.get());
    }

    public BUCKET getBucket() {
        return (BUCKET)((BucketItem)this.bucketRO.get());
    }

    void updateStill(RegistryObject<STILL> stillRO) {
        this.stillRO = Objects.requireNonNull(stillRO);
    }

    void updateFlowing(RegistryObject<FLOWING> flowingRO) {
        this.flowingRO = Objects.requireNonNull(flowingRO);
    }

    void updateBlock(RegistryObject<BLOCK> blockRO) {
        this.blockRO = Objects.requireNonNull(blockRO);
    }

    void updateBucket(RegistryObject<BUCKET> bucketRO) {
        this.bucketRO = Objects.requireNonNull(bucketRO);
    }

    @Nonnull
    public STILL getFluid() {
        return this.getStillFluid();
    }
}

