/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.BaseSlotInfo;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.EnergySlotInfo;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.HeatSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileComponentConfig
implements ITileComponent,
MekanismContainer.ISpecificContainerTracker {
    public final TileEntityMekanism tile;
    private final Map<TransmissionType, ConfigInfo> configInfo = new EnumMap<TransmissionType, ConfigInfo>(TransmissionType.class);
    private final Map<TransmissionType, List<Consumer<Direction>>> configChangeListeners = new EnumMap<TransmissionType, List<Consumer<Direction>>>(TransmissionType.class);
    private final List<TransmissionType> transmissionTypes = new ArrayList<TransmissionType>();

    public TileComponentConfig(TileEntityMekanism tile, TransmissionType ... types) {
        this.tile = tile;
        for (TransmissionType type : types) {
            this.addSupported(type);
        }
        tile.addComponent(this);
    }

    public void addConfigChangeListener(TransmissionType transmissionType, Consumer<Direction> listener) {
        this.configChangeListeners.computeIfAbsent(transmissionType, type -> new ArrayList(1)).add(listener);
    }

    public void sideChanged(TransmissionType transmissionType, RelativeSide side) {
        Direction direction = side.getDirection(this.tile.getDirection());
        this.sideChangedBasic(transmissionType, direction);
        this.tile.sendUpdatePacket();
        WorldUtils.notifyNeighborOfChange(this.tile.func_145831_w(), direction, this.tile.func_174877_v());
    }

    private void sideChangedBasic(TransmissionType transmissionType, Direction direction) {
        switch (transmissionType) {
            case ENERGY: {
                this.tile.invalidateCapabilities(EnergyCompatUtils.getEnabledEnergyCapabilities(), direction);
                break;
            }
            case FLUID: {
                this.tile.invalidateCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction);
                break;
            }
            case GAS: {
                this.tile.invalidateCapability(Capabilities.GAS_HANDLER_CAPABILITY, direction);
                break;
            }
            case INFUSION: {
                this.tile.invalidateCapability(Capabilities.INFUSION_HANDLER_CAPABILITY, direction);
                break;
            }
            case PIGMENT: {
                this.tile.invalidateCapability(Capabilities.PIGMENT_HANDLER_CAPABILITY, direction);
                break;
            }
            case SLURRY: {
                this.tile.invalidateCapability(Capabilities.SLURRY_HANDLER_CAPABILITY, direction);
                break;
            }
            case ITEM: {
                this.tile.invalidateCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction);
                break;
            }
            case HEAT: {
                this.tile.invalidateCapability(Capabilities.HEAT_HANDLER_CAPABILITY, direction);
            }
        }
        this.tile.markDirty(false);
        for (Consumer listener : this.configChangeListeners.getOrDefault(transmissionType, Collections.emptyList())) {
            listener.accept(direction);
        }
    }

    private RelativeSide getSide(Direction direction) {
        return RelativeSide.fromDirections(this.tile.getDirection(), direction);
    }

    @ComputerMethod(nameOverride="getConfigurableTypes")
    public List<TransmissionType> getTransmissions() {
        return this.transmissionTypes;
    }

    public void addSupported(TransmissionType type) {
        if (!this.configInfo.containsKey(type)) {
            this.configInfo.put(type, new ConfigInfo(this.tile::getDirection));
            this.transmissionTypes.add(type);
        }
    }

    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, Direction side) {
        ConfigInfo info;
        TransmissionType type = null;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            type = TransmissionType.ITEM;
        } else if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            type = TransmissionType.GAS;
        } else if (capability == Capabilities.INFUSION_HANDLER_CAPABILITY) {
            type = TransmissionType.INFUSION;
        } else if (capability == Capabilities.PIGMENT_HANDLER_CAPABILITY) {
            type = TransmissionType.PIGMENT;
        } else if (capability == Capabilities.SLURRY_HANDLER_CAPABILITY) {
            type = TransmissionType.SLURRY;
        } else if (capability == Capabilities.HEAT_HANDLER_CAPABILITY) {
            type = TransmissionType.HEAT;
        } else if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            type = TransmissionType.FLUID;
        } else if (EnergyCompatUtils.isEnergyCapability(capability)) {
            type = TransmissionType.ENERGY;
        }
        if (type != null && (info = this.getConfig(type)) != null && side != null) {
            ISlotInfo slotInfo = info.getSlotInfo(this.getSide(side));
            return slotInfo == null || !slotInfo.isEnabled();
        }
        return false;
    }

    @Nullable
    public ConfigInfo getConfig(TransmissionType type) {
        return this.configInfo.get(type);
    }

    public void addDisabledSides(RelativeSide ... sides) {
        for (ConfigInfo config : this.configInfo.values()) {
            config.addDisabledSides(sides);
        }
    }

    public ConfigInfo setupInputConfig(TransmissionType type, Object container) {
        ConfigInfo config = this.getConfig(type);
        if (config != null) {
            config.addSlotInfo(DataType.INPUT, TileComponentConfig.createInfo(type, true, false, container));
            config.fill(DataType.INPUT);
            config.setCanEject(false);
        }
        return config;
    }

    public ConfigInfo setupOutputConfig(TransmissionType type, Object container, RelativeSide ... sides) {
        ConfigInfo config = this.getConfig(type);
        if (config != null) {
            config.addSlotInfo(DataType.OUTPUT, TileComponentConfig.createInfo(type, false, true, container));
            config.setDataType(DataType.OUTPUT, sides);
            config.setEjecting(true);
        }
        return config;
    }

    public ConfigInfo setupIOConfig(TransmissionType type, Object inputInfo, Object outputInfo, RelativeSide outputSide) {
        return this.setupIOConfig(type, inputInfo, outputInfo, outputSide, false);
    }

    public ConfigInfo setupIOConfig(TransmissionType type, Object inputContainer, Object outputContainer, RelativeSide outputSide, boolean alwaysAllow) {
        return this.setupIOConfig(type, inputContainer, outputContainer, outputSide, alwaysAllow, alwaysAllow);
    }

    public ConfigInfo setupIOConfig(TransmissionType type, Object inputContainer, Object outputContainer, RelativeSide outputSide, boolean alwaysAllowInput, boolean alwaysAllowOutput) {
        ConfigInfo config = this.getConfig(type);
        if (config != null) {
            config.addSlotInfo(DataType.INPUT, TileComponentConfig.createInfo(type, true, alwaysAllowOutput, inputContainer));
            config.addSlotInfo(DataType.OUTPUT, TileComponentConfig.createInfo(type, alwaysAllowInput, true, outputContainer));
            config.addSlotInfo(DataType.INPUT_OUTPUT, TileComponentConfig.createInfo(type, true, true, Arrays.asList(inputContainer, outputContainer)));
            config.fill(DataType.INPUT);
            config.setDataType(DataType.OUTPUT, outputSide);
        }
        return config;
    }

    public ConfigInfo setupIOConfig(TransmissionType type, Object info, RelativeSide outputSide) {
        return this.setupIOConfig(type, info, outputSide, false);
    }

    public ConfigInfo setupIOConfig(TransmissionType type, Object info, RelativeSide outputSide, boolean alwaysAllow) {
        ConfigInfo config = this.getConfig(type);
        if (config != null) {
            config.addSlotInfo(DataType.INPUT, TileComponentConfig.createInfo(type, true, alwaysAllow, info));
            config.addSlotInfo(DataType.OUTPUT, TileComponentConfig.createInfo(type, alwaysAllow, true, info));
            config.addSlotInfo(DataType.INPUT_OUTPUT, TileComponentConfig.createInfo(type, true, true, info));
            config.fill(DataType.INPUT);
            config.setDataType(DataType.OUTPUT, outputSide);
        }
        return config;
    }

    public ConfigInfo setupItemIOConfig(IInventorySlot inputSlot, IInventorySlot outputSlot, IInventorySlot energySlot) {
        return this.setupItemIOConfig(Collections.singletonList(inputSlot), Collections.singletonList(outputSlot), energySlot, false);
    }

    public ConfigInfo setupItemIOConfig(List<IInventorySlot> inputSlots, List<IInventorySlot> outputSlots, IInventorySlot energySlot, boolean alwaysAllow) {
        ConfigInfo itemConfig = this.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.INPUT, new InventorySlotInfo(true, alwaysAllow, inputSlots));
            itemConfig.addSlotInfo(DataType.OUTPUT, new InventorySlotInfo(alwaysAllow, true, outputSlots));
            ArrayList<IInventorySlot> ioSlots = new ArrayList<IInventorySlot>(inputSlots);
            ioSlots.addAll(outputSlots);
            itemConfig.addSlotInfo(DataType.INPUT_OUTPUT, new InventorySlotInfo(true, true, ioSlots));
            itemConfig.addSlotInfo(DataType.ENERGY, new InventorySlotInfo(true, true, energySlot));
            itemConfig.setDefaults();
        }
        return itemConfig;
    }

    public ConfigInfo setupItemIOExtraConfig(IInventorySlot inputSlot, IInventorySlot outputSlot, IInventorySlot extraSlot, IInventorySlot energySlot) {
        ConfigInfo itemConfig = this.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.INPUT, new InventorySlotInfo(true, false, inputSlot));
            itemConfig.addSlotInfo(DataType.OUTPUT, new InventorySlotInfo(false, true, outputSlot));
            itemConfig.addSlotInfo(DataType.INPUT_OUTPUT, new InventorySlotInfo(true, true, inputSlot, outputSlot));
            itemConfig.addSlotInfo(DataType.EXTRA, new InventorySlotInfo(true, true, extraSlot));
            itemConfig.addSlotInfo(DataType.ENERGY, new InventorySlotInfo(true, true, energySlot));
            itemConfig.setDefaults();
        }
        return itemConfig;
    }

    @Nullable
    public DataType getDataType(TransmissionType type, RelativeSide side) {
        ConfigInfo info = this.getConfig(type);
        if (info == null) {
            return null;
        }
        return info.getDataType(side);
    }

    @Nullable
    public ISlotInfo getSlotInfo(TransmissionType type, Direction direction) {
        if (direction == null) {
            return null;
        }
        ConfigInfo info = this.getConfig(type);
        if (info == null) {
            return null;
        }
        return info.getSlotInfo(this.getSide(direction));
    }

    public boolean supports(TransmissionType type) {
        return this.configInfo.containsKey(type);
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        if (nbtTags.func_150297_b("componentConfig", 10)) {
            CompoundNBT configNBT = nbtTags.func_74775_l("componentConfig");
            EnumSet<Direction> directionsToUpdate = EnumSet.noneOf(Direction.class);
            for (Map.Entry<TransmissionType, ConfigInfo> entry : this.configInfo.entrySet()) {
                TransmissionType type = entry.getKey();
                ConfigInfo info = entry.getValue();
                info.setEjecting(configNBT.func_74767_n("eject" + type.ordinal()));
                CompoundNBT sideConfig = configNBT.func_74775_l("config" + type.ordinal());
                for (RelativeSide side : EnumUtils.SIDES) {
                    NBTUtils.setEnumIfPresent(sideConfig, "side" + side.ordinal(), DataType::byIndexStatic, dataType -> {
                        if (info.getDataType(side) != dataType) {
                            info.setDataType((DataType)dataType, side);
                            if (this.tile.func_145830_o()) {
                                Direction direction = side.getDirection(this.tile.getDirection());
                                this.sideChangedBasic(type, direction);
                                directionsToUpdate.add(direction);
                            }
                        }
                    });
                }
            }
            WorldUtils.notifyNeighborsOfChange(this.tile.func_145831_w(), this.tile.func_174877_v(), directionsToUpdate);
        }
    }

    @Override
    public void write(CompoundNBT nbtTags) {
        CompoundNBT configNBT = new CompoundNBT();
        for (Map.Entry<TransmissionType, ConfigInfo> entry : this.configInfo.entrySet()) {
            TransmissionType type = entry.getKey();
            ConfigInfo info = entry.getValue();
            configNBT.func_74757_a("eject" + type.ordinal(), info.isEjecting());
            CompoundNBT sideConfig = new CompoundNBT();
            for (RelativeSide side : EnumUtils.SIDES) {
                sideConfig.func_74768_a("side" + side.ordinal(), info.getDataType(side).ordinal());
            }
            configNBT.func_218657_a("config" + type.ordinal(), (INBT)sideConfig);
        }
        nbtTags.func_218657_a("componentConfig", (INBT)configNBT);
    }

    @Override
    public void addToUpdateTag(CompoundNBT updateTag) {
        CompoundNBT configNBT = new CompoundNBT();
        for (Map.Entry<TransmissionType, ConfigInfo> entry : this.configInfo.entrySet()) {
            TransmissionType type = entry.getKey();
            ConfigInfo info = entry.getValue();
            CompoundNBT sideConfig = new CompoundNBT();
            for (RelativeSide side : EnumUtils.SIDES) {
                sideConfig.func_74768_a("side" + side.ordinal(), info.getDataType(side).ordinal());
            }
            configNBT.func_218657_a("config" + type.ordinal(), (INBT)sideConfig);
        }
        updateTag.func_218657_a("componentConfig", (INBT)configNBT);
    }

    @Override
    public void readFromUpdateTag(CompoundNBT updateTag) {
        if (updateTag.func_150297_b("componentConfig", 10)) {
            CompoundNBT configNBT = updateTag.func_74775_l("componentConfig");
            for (Map.Entry<TransmissionType, ConfigInfo> entry : this.configInfo.entrySet()) {
                TransmissionType type = entry.getKey();
                ConfigInfo info = entry.getValue();
                CompoundNBT sideConfig = configNBT.func_74775_l("config" + type.ordinal());
                for (RelativeSide side : EnumUtils.SIDES) {
                    NBTUtils.setEnumIfPresent(sideConfig, "side" + side.ordinal(), DataType::byIndexStatic, dataType -> info.setDataType((DataType)dataType, side));
                }
            }
        }
    }

    @Override
    public List<ISyncableData> getSpecificSyncableData() {
        ArrayList<ISyncableData> list = new ArrayList<ISyncableData>();
        List<TransmissionType> transmissions = this.getTransmissions();
        for (TransmissionType transmission : transmissions) {
            ConfigInfo info = this.configInfo.get(transmission);
            list.add(SyncableBoolean.create(info::isEjecting, info::setEjecting));
        }
        return list;
    }

    public static BaseSlotInfo createInfo(TransmissionType type, boolean input, boolean output, Object ... containers) {
        return TileComponentConfig.createInfo(type, input, output, Arrays.asList(containers));
    }

    public static BaseSlotInfo createInfo(TransmissionType type, boolean input, boolean output, List<?> containers) {
        switch (type) {
            case ITEM: {
                return new InventorySlotInfo(input, output, containers);
            }
            case FLUID: {
                return new FluidSlotInfo(input, output, containers);
            }
            case GAS: {
                return new ChemicalSlotInfo.GasSlotInfo(input, output, (List<IGasTank>)containers);
            }
            case INFUSION: {
                return new ChemicalSlotInfo.InfusionSlotInfo(input, output, (List<IInfusionTank>)containers);
            }
            case PIGMENT: {
                return new ChemicalSlotInfo.PigmentSlotInfo(input, output, (List<IPigmentTank>)containers);
            }
            case SLURRY: {
                return new ChemicalSlotInfo.SlurrySlotInfo(input, output, (List<ISlurryTank>)containers);
            }
            case ENERGY: {
                return new EnergySlotInfo(input, output, containers);
            }
            case HEAT: {
                return new HeatSlotInfo(input, output, containers);
            }
        }
        return null;
    }

    private void validateSupportedTransmissionType(TransmissionType type) throws ComputerException {
        if (!this.supports(type)) {
            throw new ComputerException("This machine does not support configuring transmission type '%s'.", type);
        }
    }

    @ComputerMethod
    private boolean canEject(TransmissionType type) throws ComputerException {
        this.validateSupportedTransmissionType(type);
        return this.configInfo.get(type).canEject();
    }

    @ComputerMethod
    private boolean isEjecting(TransmissionType type) throws ComputerException {
        this.validateSupportedTransmissionType(type);
        return this.configInfo.get(type).isEjecting();
    }

    @ComputerMethod
    private void setEjecting(TransmissionType type, boolean ejecting) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateSupportedTransmissionType(type);
        ConfigInfo config = this.configInfo.get(type);
        if (!config.canEject()) {
            throw new ComputerException("This machine does not support auto-ejecting for transmission type '%s'.", type);
        }
        if (config.isEjecting() != ejecting) {
            config.setEjecting(ejecting);
            this.tile.markDirty(false);
        }
    }

    @ComputerMethod
    private Set<DataType> getSupportedModes(TransmissionType type) throws ComputerException {
        this.validateSupportedTransmissionType(type);
        return this.configInfo.get(type).getSupportedDataTypes();
    }

    @ComputerMethod
    private DataType getMode(TransmissionType type, RelativeSide side) throws ComputerException {
        this.validateSupportedTransmissionType(type);
        return this.configInfo.get(type).getDataType(side);
    }

    @ComputerMethod
    private void setMode(TransmissionType type, RelativeSide side, DataType mode) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateSupportedTransmissionType(type);
        ConfigInfo config = this.configInfo.get(type);
        if (!config.getSupportedDataTypes().contains(mode)) {
            throw new ComputerException("This machine does not support mode '%s' for transmission type '%s'.", mode, type);
        }
        DataType currentMode = config.getDataType(side);
        if (mode != currentMode) {
            config.setDataType(mode, side);
            this.sideChanged(type, side);
        }
    }

    @ComputerMethod
    private void incrementMode(TransmissionType type, RelativeSide side) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateSupportedTransmissionType(type);
        ConfigInfo configInfo = this.configInfo.get(type);
        if (configInfo.getDataType(side) != configInfo.incrementDataType(side)) {
            this.sideChanged(type, side);
        }
    }

    @ComputerMethod
    private void decrementMode(TransmissionType type, RelativeSide side) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateSupportedTransmissionType(type);
        ConfigInfo configInfo = this.configInfo.get(type);
        if (configInfo.getDataType(side) != configInfo.decrementDataType(side)) {
            this.sideChanged(type, side);
        }
    }
}

