/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.factory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.SawmillCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.Mekanism;
import mekanism.common.base.ProcessInfo;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.slot.FactoryInputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.upgrade.SawmillUpgradeData;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntitySawingFactory
extends TileEntityFactory<SawmillRecipe>
implements ISingleRecipeLookupHandler.ItemRecipeLookupHandler<SawmillRecipe> {
    protected IInputHandler<@NonNull ItemStack>[] inputHandlers;
    protected IOutputHandler<@NonNull SawmillRecipe.ChanceOutput>[] outputHandlers;

    public TileEntitySawingFactory(IBlockProvider blockProvider) {
        super(blockProvider);
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener updateSortingListener) {
        int baseX;
        this.inputHandlers = new IInputHandler[this.tier.processes];
        this.outputHandlers = new IOutputHandler[this.tier.processes];
        this.processInfoSlots = new ProcessInfo[this.tier.processes];
        int n = this.tier == FactoryTier.BASIC ? 55 : (this.tier == FactoryTier.ADVANCED ? 35 : (baseX = this.tier == FactoryTier.ELITE ? 29 : 27));
        int baseXMult = this.tier == FactoryTier.BASIC ? 38 : (this.tier == FactoryTier.ADVANCED ? 26 : 19);
        for (int i = 0; i < this.tier.processes; ++i) {
            int xPos = baseX + i * baseXMult;
            OutputInventorySlot outputSlot = OutputInventorySlot.at(updateSortingListener, xPos, 57);
            OutputInventorySlot secondaryOutputSlot = OutputInventorySlot.at(updateSortingListener, xPos, 77);
            FactoryInputInventorySlot inputSlot = FactoryInputInventorySlot.create(this, i, outputSlot, secondaryOutputSlot, this.recipeCacheLookupMonitors[i], xPos, 13);
            builder.addSlot(inputSlot);
            builder.addSlot(outputSlot);
            builder.addSlot(secondaryOutputSlot);
            this.inputHandlers[i] = InputHelper.getInputHandler(inputSlot);
            this.outputHandlers[i] = OutputHelper.getOutputHandler(outputSlot, (IInventorySlot)secondaryOutputSlot);
            this.processInfoSlots[i] = new ProcessInfo(i, inputSlot, outputSlot, secondaryOutputSlot);
        }
    }

    @Override
    public boolean isValidInputItem(@Nonnull ItemStack stack) {
        return this.containsRecipe(stack);
    }

    @Override
    protected int getNeededInput(SawmillRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt(recipe.getInput().getNeededAmount(inputStack));
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<SawmillRecipe> cached, @Nonnull ItemStack stack) {
        return cached != null && cached.getRecipe().getInput().testType(stack);
    }

    @Override
    protected SawmillRecipe findRecipe(int process, @Nonnull ItemStack fallbackInput, @Nonnull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        ItemStack output = outputSlot.getStack();
        ItemStack extra = secondaryOutputSlot == null ? ItemStack.field_190927_a : secondaryOutputSlot.getStack();
        return this.getRecipeType().getInputCache().findTypeBasedRecipe(this.field_145850_b, fallbackInput, recipe -> {
            SawmillRecipe.ChanceOutput chanceOutput = recipe.getOutput(fallbackInput);
            if (InventoryUtils.areItemsStackable(chanceOutput.getMainOutput(), output)) {
                if (extra.func_190926_b()) {
                    return true;
                }
                ItemStack secondaryOutput = chanceOutput.getMaxSecondaryOutput();
                return secondaryOutput.func_190926_b() || ItemHandlerHelper.canItemStacksStack((ItemStack)secondaryOutput, (ItemStack)extra);
            }
            return false;
        });
    }

    @Override
    @Nonnull
    public MekanismRecipeType<SawmillRecipe, InputRecipeCache.SingleItem<SawmillRecipe>> getRecipeType() {
        return MekanismRecipeType.SAWING;
    }

    @Override
    @Nullable
    public SawmillRecipe getRecipe(int cacheIndex) {
        return (SawmillRecipe)this.findFirstRecipe(this.inputHandlers[cacheIndex]);
    }

    @Override
    @Nonnull
    public CachedRecipe<SawmillRecipe> createNewCachedRecipe(@Nonnull SawmillRecipe recipe, int cacheIndex) {
        return new SawmillCachedRecipe(recipe, this.inputHandlers[cacheIndex], this.outputHandlers[cacheIndex]).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    @Override
    public void parseUpgradeData(@Nonnull IUpgradeData upgradeData) {
        if (upgradeData instanceof SawmillUpgradeData) {
            super.parseUpgradeData(upgradeData);
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @Override
    @Nonnull
    public SawmillUpgradeData getUpgradeData() {
        return new SawmillUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, this.energySlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }

    @ComputerMethod
    private ItemStack getSecondaryOutput(int process) throws ComputerException {
        this.validateValidProcess(process);
        IInventorySlot secondaryOutputSlot = this.processInfoSlots[process].getSecondaryOutputSlot();
        return secondaryOutputSlot == null ? ItemStack.field_190927_a : secondaryOutputSlot.getStack();
    }
}

