/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.interfaces;

import javax.annotation.Nonnull;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import net.minecraft.util.text.ITextComponent;

public interface IRedstoneControl {
    public RedstoneControl getControlType();

    public void setControlType(RedstoneControl var1);

    public boolean isPowered();

    public boolean wasPowered();

    public boolean canPulse();

    public static enum RedstoneControl implements IIncrementalEnum<RedstoneControl>,
    IHasTextComponent
    {
        DISABLED(MekanismLang.REDSTONE_CONTROL_DISABLED),
        HIGH(MekanismLang.REDSTONE_CONTROL_HIGH),
        LOW(MekanismLang.REDSTONE_CONTROL_LOW),
        PULSE(MekanismLang.REDSTONE_CONTROL_PULSE);

        private static final RedstoneControl[] MODES;
        private final ILangEntry langEntry;

        private RedstoneControl(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.langEntry.translate(new Object[0]);
        }

        @Override
        @Nonnull
        public RedstoneControl byIndex(int index) {
            return RedstoneControl.byIndexStatic(index);
        }

        public static RedstoneControl byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = RedstoneControl.values();
        }
    }
}

