/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.common.base.MekFakePlayer;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MinerEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.miner.ThreadMinerSearch;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.SyncableRegistryEntry;
import mekanism.common.inventory.container.sync.list.SyncableFilterList;
import mekanism.common.inventory.container.tile.DigitalMinerConfigContainer;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.lib.chunkloading.IChunkLoader;
import mekanism.common.lib.collection.HashList;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.TileTransitRequest;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.interfaces.IHasSortableFilters;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.util.UpgradeUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.Region;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityDigitalMiner
extends TileEntityMekanism
implements ISustainedData,
IChunkLoader,
IBoundingBlock,
ITileFilterHolder<MinerFilter<?>>,
IHasSortableFilters {
    private Long2ObjectMap<BitSet> oresToMine = Long2ObjectMaps.emptyMap();
    private HashList<MinerFilter<?>> filters = new HashList();
    public ThreadMinerSearch searcher = new ThreadMinerSearch(this);
    private int radius;
    private boolean inverse;
    private boolean inverseRequiresReplacement;
    private Item inverseReplaceTarget = Items.field_190931_a;
    private int minY;
    private int maxY = 60;
    private boolean doEject = false;
    private boolean doPull = false;
    public ItemStack missingStack = ItemStack.field_190927_a;
    private int delay;
    private int delayLength;
    private int cachedToMine;
    private boolean silkTouch;
    private boolean running;
    private int delayTicks;
    private boolean initCalc;
    private int numPowering;
    public boolean clientRendering;
    private final TileComponentChunkLoader<TileEntityDigitalMiner> chunkLoaderComponent;
    @Nullable
    private ChunkPos targetChunk;
    private MinerEnergyContainer energyContainer;
    private List<IInventorySlot> mainSlots;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityDigitalMiner() {
        super(MekanismBlocks.DIGITAL_MINER);
        this.delayLength = MekanismConfig.general.minerTicksPerMine.get();
        this.initCalc = false;
        this.clientRendering = false;
        this.chunkLoaderComponent = new TileComponentChunkLoader<TileEntityDigitalMiner>(this);
        this.radius = 10;
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
        this.addDisabledCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MinerEnergyContainer.input(this);
        builder.addContainer(this.energyContainer, RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BOTTOM);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        this.mainSlots = new ArrayList<IInventorySlot>();
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection, side -> side == RelativeSide.TOP, side -> side == RelativeSide.BACK);
        BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canInsert = (stack, automationType) -> automationType != AutomationType.EXTERNAL || this.isReplaceTarget(stack.func_77973_b());
        BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canExtract = (stack, automationType) -> automationType == AutomationType.MANUAL || !this.isReplaceTarget(stack.func_77973_b());
        for (int slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                BasicInventorySlot slot = BasicInventorySlot.at(canExtract, canInsert, (IContentsListener)this, 8 + slotX * 18, 92 + slotY * 18);
                builder.addSlot(slot, RelativeSide.BACK, RelativeSide.TOP);
                this.mainSlots.add(slot);
            }
        }
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityDigitalMiner)this).func_145831_w(), this, 152, 20);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    private void closeInvalidScreens() {
        if (this.getActive() && !this.playersUsing.isEmpty()) {
            for (PlayerEntity player : new ObjectOpenHashSet((Collection)this.playersUsing)) {
                if (!(player.field_71070_bA instanceof DigitalMinerConfigContainer)) continue;
                player.func_71053_j();
            }
        }
    }

    @Override
    protected void onUpdateClient() {
        super.onUpdateClient();
        this.closeInvalidScreens();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.closeInvalidScreens();
        if (!this.initCalc) {
            if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
                boolean prevRunning = this.running;
                this.reset();
                this.start();
                this.running = prevRunning;
            }
            this.initCalc = true;
        }
        this.energySlot.fillContainerOrConvert();
        if (MekanismUtils.canFunction(this) && this.running && this.searcher.state == ThreadMinerSearch.State.FINISHED && !this.oresToMine.isEmpty()) {
            FloatingLong energyPerTick = this.energyContainer.getEnergyPerTick();
            if (this.energyContainer.extract(energyPerTick, Action.SIMULATE, AutomationType.INTERNAL).equals(energyPerTick)) {
                this.setActive(true);
                if (this.delay > 0) {
                    --this.delay;
                }
                this.energyContainer.extract(energyPerTick, Action.EXECUTE, AutomationType.INTERNAL);
                if (this.delay == 0) {
                    this.tryMineBlock();
                    this.delay = this.getDelay();
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        if (this.doEject && this.delayTicks == 0) {
            Direction oppositeDirection = this.getOppositeDirection();
            TileEntity ejectInv = WorldUtils.getTileEntity((IBlockReader)this.field_145850_b, this.func_174877_v().func_177984_a().func_177967_a(oppositeDirection, 2));
            TileEntity ejectTile = WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177984_a().func_177972_a(oppositeDirection));
            if (ejectInv != null && ejectTile != null) {
                TransitRequest.TransitResponse response;
                TileTransitRequest ejectMap = InventoryUtils.getEjectItemMap(ejectTile, oppositeDirection, this.mainSlots);
                if (!ejectMap.isEmpty() && !(response = ejectInv instanceof TileEntityLogisticalTransporterBase ? ((TileEntityLogisticalTransporterBase)ejectInv).getTransmitter().insert(ejectTile, (TransitRequest)ejectMap, null, true, 0) : ejectMap.addToInventory(ejectInv, oppositeDirection, 0, false)).isEmpty()) {
                    response.useAll();
                }
                this.delayTicks = 10;
            }
        } else if (this.delayTicks > 0) {
            --this.delayTicks;
        }
    }

    public void updateFromSearch(Long2ObjectMap<BitSet> oresToMine, int found) {
        this.oresToMine = oresToMine;
        this.cachedToMine = found;
        this.updateTargetChunk(null);
        this.markDirty(false);
    }

    public int getDelay() {
        return this.delayLength;
    }

    @ComputerMethod
    public boolean getSilkTouch() {
        return this.silkTouch;
    }

    @ComputerMethod
    public int getRadius() {
        return this.radius;
    }

    @ComputerMethod
    public int getMinY() {
        return this.minY;
    }

    @ComputerMethod
    public int getMaxY() {
        return this.maxY;
    }

    @ComputerMethod(nameOverride="getInverseMode")
    public boolean getInverse() {
        return this.inverse;
    }

    @ComputerMethod(nameOverride="getInverseModeRequiresReplacement")
    public boolean getInverseRequiresReplacement() {
        return this.inverseRequiresReplacement;
    }

    @ComputerMethod(nameOverride="getInverseModeReplaceTarget")
    public Item getInverseReplaceTarget() {
        return this.inverseReplaceTarget;
    }

    private void setSilkTouch(boolean newSilkTouch) {
        boolean changed = this.silkTouch != newSilkTouch;
        this.silkTouch = newSilkTouch;
        if (changed && this.func_145830_o() && !this.isRemote()) {
            this.energyContainer.updateMinerEnergyPerTick();
        }
    }

    public void toggleSilkTouch() {
        this.setSilkTouch(!this.getSilkTouch());
        this.markDirty(false);
    }

    public void toggleInverse() {
        this.inverse = !this.inverse;
        this.markDirty(false);
    }

    public void toggleInverseRequiresReplacement() {
        this.inverseRequiresReplacement = !this.inverseRequiresReplacement;
        this.markDirty(false);
    }

    public void setInverseReplaceTarget(Item target) {
        if (target != this.inverseReplaceTarget) {
            this.inverseReplaceTarget = target;
            this.markDirty(false);
        }
    }

    public void toggleAutoEject() {
        this.doEject = !this.doEject;
        this.markDirty(false);
    }

    public void toggleAutoPull() {
        this.doPull = !this.doPull;
        this.markDirty(false);
    }

    public void setRadiusFromPacket(int newRadius) {
        this.setRadius(Math.min(Math.max(0, newRadius), MekanismConfig.general.minerMaxRadius.get()));
        this.sendUpdatePacket();
        this.markDirty(false);
    }

    private void setRadius(int newRadius) {
        boolean changed = this.radius != newRadius;
        this.radius = newRadius;
        if (changed && this.func_145830_o() && !this.isRemote()) {
            this.energyContainer.updateMinerEnergyPerTick();
            this.getChunkLoader().refreshChunkTickets();
        }
    }

    public void setMinYFromPacket(int newMinY) {
        this.setMinY(Math.min(Math.max(0, newMinY), this.getMaxY()));
        this.sendUpdatePacket();
        this.markDirty(false);
    }

    private void setMinY(int newMinY) {
        boolean changed = this.minY != newMinY;
        this.minY = newMinY;
        if (changed && this.func_145830_o() && !this.isRemote()) {
            this.energyContainer.updateMinerEnergyPerTick();
        }
    }

    public void setMaxYFromPacket(int newMaxY) {
        if (this.field_145850_b != null) {
            this.setMaxY(Math.max(Math.min(newMaxY, this.field_145850_b.func_217301_I() - 1), this.getMinY()));
            this.sendUpdatePacket();
            this.markDirty(false);
        }
    }

    private void setMaxY(int newMaxY) {
        boolean changed = this.maxY != newMaxY;
        this.maxY = newMaxY;
        if (changed && this.func_145830_o() && !this.isRemote()) {
            this.energyContainer.updateMinerEnergyPerTick();
        }
    }

    @Override
    public void moveUp(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex - 1);
        this.markDirty(false);
    }

    @Override
    public void moveDown(int filterIndex) {
        this.filters.swap(filterIndex, filterIndex + 1);
        this.markDirty(false);
    }

    private void tryMineBlock() {
        long target = this.targetChunk == null ? ChunkPos.field_222244_a : this.targetChunk.func_201841_a();
        ObjectIterator it = this.oresToMine.long2ObjectEntrySet().iterator();
        block0: while (it.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
            long chunk = entry.getLongKey();
            BitSet chunkToMine = (BitSet)entry.getValue();
            ChunkPos currentChunk = null;
            if (target == chunk) {
                currentChunk = this.targetChunk;
            }
            int next = 0;
            while (true) {
                BlockState state;
                BlockPos pos;
                Optional<BlockState> blockState;
                int index;
                if ((index = chunkToMine.nextSetBit(next)) == -1) {
                    it.remove();
                    continue block0;
                }
                if (currentChunk == null) {
                    currentChunk = new ChunkPos(chunk);
                    this.updateTargetChunk(currentChunk);
                    target = chunk;
                }
                if ((blockState = WorldUtils.getBlockState((IBlockReader)this.field_145850_b, pos = this.getPosFromIndex(index))).isPresent() && !(state = blockState.get()).isAir((IBlockReader)this.field_145850_b, pos) && !state.func_235714_a_(MekanismTags.Blocks.MINER_BLACKLIST)) {
                    MinerFilter<?> matchingFilter = null;
                    for (MinerFilter<?> filter : this.filters) {
                        if (!filter.canFilter(state)) continue;
                        matchingFilter = filter;
                        break;
                    }
                    if (this.inverse == (matchingFilter == null) && this.canMine(state, pos)) {
                        List<ItemStack> drops = this.getDrops(state, pos);
                        if (this.canInsert(drops) && this.setReplace(pos, matchingFilter)) {
                            this.add(drops);
                            this.missingStack = ItemStack.field_190927_a;
                            this.field_145850_b.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
                            --this.cachedToMine;
                            chunkToMine.clear(index);
                            if (chunkToMine.isEmpty()) {
                                it.remove();
                                this.updateTargetChunk(null);
                            }
                        }
                        return;
                    }
                }
                --this.cachedToMine;
                chunkToMine.clear(index);
                if (chunkToMine.isEmpty()) {
                    it.remove();
                    continue block0;
                }
                next = index + 1;
            }
        }
        this.updateTargetChunk(null);
    }

    private boolean setReplace(BlockPos pos, @Nullable MinerFilter<?> filter) {
        ItemStack stack;
        Item replaceTarget;
        if (this.field_145850_b == null) {
            return false;
        }
        if (filter == null) {
            replaceTarget = this.inverseReplaceTarget;
            stack = this.getReplace(replaceTarget, this::inverseReplaceTargetMatches);
        } else {
            replaceTarget = filter.replaceTarget;
            stack = this.getReplace(replaceTarget, filter::replaceTargetMatches);
        }
        if (stack.func_190926_b()) {
            if (replaceTarget == Items.field_190931_a || filter == null && !this.inverseRequiresReplacement || filter != null && !filter.requiresReplacement) {
                this.field_145850_b.func_217377_a(pos, false);
                return true;
            }
            this.missingStack = new ItemStack((IItemProvider)replaceTarget);
            return false;
        }
        BlockState newState = MekFakePlayer.withFakePlayer((ServerWorld)this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), fakePlayer -> StackUtils.getStateForPlacement(stack, pos, (PlayerEntity)fakePlayer));
        if (newState == null || !newState.func_196955_c((IWorldReader)this.field_145850_b, pos)) {
            return false;
        }
        this.field_145850_b.func_175656_a(pos, newState);
        return true;
    }

    private boolean canMine(BlockState state, BlockPos pos) {
        return MekFakePlayer.withFakePlayer((ServerWorld)this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), dummy -> {
            dummy.setEmulatingUUID(this.getOwnerUUID());
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.field_145850_b, pos, state, (PlayerEntity)dummy);
            return !MinecraftForge.EVENT_BUS.post((Event)event);
        });
    }

    private ItemStack getReplace(Item replaceTarget, Predicate<Item> replaceStackMatches) {
        TransitRequest.TransitResponse response;
        TransitRequest request;
        TileEntity pullInv;
        if (replaceTarget == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        for (IInventorySlot slot : this.mainSlots) {
            ItemStack slotStack = slot.getStack();
            if (!replaceStackMatches.test(slotStack.func_77973_b())) continue;
            MekanismUtils.logMismatchedStackSize(slot.shrinkStack(1, Action.EXECUTE), 1L);
            return StackUtils.size(slotStack, 1);
        }
        if ((replaceTarget == Items.field_221585_m || replaceTarget == Items.field_221574_b) && this.upgradeComponent.isUpgradeInstalled(Upgrade.STONE_GENERATOR)) {
            return new ItemStack((IItemProvider)replaceTarget);
        }
        if (this.doPull && (pullInv = this.getPullInv()) != null && InventoryUtils.isItemHandler(pullInv, Direction.DOWN) && !(request = TransitRequest.definedItem(pullInv, Direction.DOWN, 1, Finder.item(replaceTarget))).isEmpty() && (response = request.createSimpleResponse()).useAll().func_190926_b()) {
            return StackUtils.size(response.getStack(), 1);
        }
        return ItemStack.field_190927_a;
    }

    public boolean canInsert(List<ItemStack> toInsert) {
        if (toInsert.isEmpty()) {
            return true;
        }
        int slots = this.mainSlots.size();
        Int2ObjectOpenHashMap cachedStacks = new Int2ObjectOpenHashMap();
        for (ItemStack stackToInsert : toInsert) {
            if (stackToInsert.func_190926_b()) continue;
            ItemStack stack = stackToInsert.func_77946_l();
            for (int i = 0; i < slots; ++i) {
                IInventorySlot slot = this.mainSlots.get(i);
                boolean wasEmpty = slot.isEmpty();
                if (wasEmpty && cachedStacks.containsKey(i)) {
                    ItemCount cachedItem = (ItemCount)cachedStacks.get(i);
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)cachedItem.stack)) continue;
                    int limit = slot.getLimit(stack);
                    int stackSize = stack.func_190916_E();
                    int total = stackSize + cachedItem.count;
                    if (total <= limit) {
                        cachedItem.count = total;
                        stack = ItemStack.field_190927_a;
                        break;
                    }
                    int toAdd = total - limit;
                    if (toAdd <= 0) continue;
                    ItemCount itemCount = cachedItem;
                    itemCount.count = itemCount.count + toAdd;
                    stack = StackUtils.size(stack, stackSize - toAdd);
                    continue;
                }
                int stackSize = stack.func_190916_E();
                stack = slot.insertItem(stack, Action.SIMULATE, AutomationType.INTERNAL);
                int remainderSize = stack.func_190916_E();
                if (wasEmpty && remainderSize < stackSize) {
                    cachedStacks.put(i, (Object)new ItemCount(stackToInsert, stackSize - remainderSize));
                }
                if (stack.func_190926_b()) break;
            }
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private TileEntity getPullInv() {
        return WorldUtils.getTileEntity((IBlockReader)this.func_145831_w(), this.func_174877_v().func_177981_b(2));
    }

    private void add(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            IInventorySlot slot;
            Iterator<IInventorySlot> iterator = this.mainSlots.iterator();
            while (iterator.hasNext() && !(stack = (slot = iterator.next()).insertItem(stack, Action.EXECUTE, AutomationType.INTERNAL)).func_190926_b()) {
            }
        }
    }

    public void start() {
        if (this.func_145831_w() == null) {
            return;
        }
        if (this.searcher.state == ThreadMinerSearch.State.IDLE) {
            BlockPos startingPos = this.getStartingPos();
            this.searcher.setChunkCache(new Region(this.func_145831_w(), startingPos, startingPos.func_177982_a(this.getDiameter(), this.getMaxY() - this.getMinY() + 1, this.getDiameter())));
            this.searcher.start();
        }
        this.running = true;
        this.markDirty(false);
    }

    public void stop() {
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            this.searcher.interrupt();
            this.reset();
        } else if (this.searcher.state == ThreadMinerSearch.State.FINISHED) {
            this.running = false;
            this.markDirty(false);
            this.updateTargetChunk(null);
        }
    }

    public void reset() {
        this.searcher = new ThreadMinerSearch(this);
        this.running = false;
        this.cachedToMine = 0;
        this.oresToMine = Long2ObjectMaps.emptyMap();
        this.missingStack = ItemStack.field_190927_a;
        this.setActive(false);
        this.updateTargetChunk(null);
        this.markDirty(false);
    }

    public boolean isReplaceTarget(Item target) {
        if (this.inverse) {
            return this.inverseReplaceTargetMatches(target);
        }
        for (MinerFilter<?> filter : this.filters) {
            if (!filter.replaceTargetMatches(target)) continue;
            return true;
        }
        return false;
    }

    private boolean inverseReplaceTargetMatches(Item target) {
        return this.inverseReplaceTarget != Items.field_190931_a && this.inverseReplaceTarget == target;
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbtTags) {
        super.func_230337_a_(state, nbtTags);
        this.running = nbtTags.func_74767_n("running");
        this.delay = nbtTags.func_74762_e("delay");
        this.numPowering = nbtTags.func_74762_e("numPowering");
        NBTUtils.setEnumIfPresent(nbtTags, "state", ThreadMinerSearch.State::byIndexStatic, s -> {
            this.searcher.state = s;
        });
        this.energyContainer.updateMinerEnergyPerTick();
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.searcher.state == ThreadMinerSearch.State.SEARCHING) {
            this.reset();
        }
        nbtTags.func_74757_a("running", this.running);
        nbtTags.func_74768_a("delay", this.delay);
        nbtTags.func_74768_a("numPowering", this.numPowering);
        nbtTags.func_74768_a("state", this.searcher.state.ordinal());
        return nbtTags;
    }

    public int getTotalSize() {
        return this.getDiameter() * this.getDiameter() * (this.getMaxY() - this.getMinY() + 1);
    }

    public int getDiameter() {
        return this.radius * 2 + 1;
    }

    public BlockPos getStartingPos() {
        return new BlockPos(this.func_174877_v().func_177958_n() - this.radius, this.getMinY(), this.func_174877_v().func_177952_p() - this.radius);
    }

    private BlockPos getPosFromIndex(int index) {
        int diameter = this.getDiameter();
        BlockPos start = this.getStartingPos();
        return start.func_177982_a(index % diameter, index / diameter / diameter, index / diameter % diameter);
    }

    @Override
    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.clientRendering) {
            return INFINITE_EXTENT_AABB;
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public void onPlace() {
        super.onPlace();
        if (this.field_145850_b != null) {
            BlockPos pos = this.func_174877_v();
            for (int x = -1; x <= 1; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        BlockPos boundingPos = pos.func_177982_a(x, y, z);
                        WorldUtils.makeAdvancedBoundingBlock((IWorld)this.field_145850_b, boundingPos, pos);
                        this.field_145850_b.func_195593_d(boundingPos, this.getBlockType());
                    }
                }
            }
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        this.field_145850_b.func_217377_a(this.func_174877_v().func_177982_a(x, y, z), false);
                    }
                }
            }
        }
    }

    @Override
    public void onBoundingBlockPowerChange(BlockPos boundingPos, int oldLevel, int newLevel) {
        if (oldLevel > 0) {
            if (newLevel == 0) {
                --this.numPowering;
            }
        } else if (newLevel > 0) {
            ++this.numPowering;
        }
    }

    @Override
    public int getBoundingComparatorSignal(Vector3i offset) {
        Direction facing = this.getDirection();
        Direction back = facing.func_176734_d();
        if (offset.equals((Object)new Vector3i(back.func_82601_c(), 1, back.func_82599_e()))) {
            return this.getCurrentRedstoneLevel();
        }
        Direction left = MekanismUtils.getLeft(facing);
        if (offset.equals((Object)new Vector3i(left.func_82601_c(), 0, left.func_82599_e()))) {
            return this.getCurrentRedstoneLevel();
        }
        Direction right = left.func_176734_d();
        if (offset.equals((Object)new Vector3i(right.func_82601_c(), 0, right.func_82599_e()))) {
            return this.getCurrentRedstoneLevel();
        }
        return 0;
    }

    @Override
    protected void notifyComparatorChange() {
        super.notifyComparatorChange();
        Direction facing = this.getDirection();
        Direction left = MekanismUtils.getLeft(facing);
        this.field_145850_b.func_175666_e(this.field_174879_c.func_177972_a(left), (Block)MekanismBlocks.ADVANCED_BOUNDING_BLOCK.getBlock());
        this.field_145850_b.func_175666_e(this.field_174879_c.func_177972_a(left.func_176734_d()), (Block)MekanismBlocks.ADVANCED_BOUNDING_BLOCK.getBlock());
        this.field_145850_b.func_175666_e(this.field_174879_c.func_177972_a(facing.func_176734_d()).func_177984_a(), (Block)MekanismBlocks.ADVANCED_BOUNDING_BLOCK.getBlock());
    }

    @Override
    protected void addGeneralPersistentData(CompoundNBT data) {
        super.addGeneralPersistentData(data);
        data.func_74768_a("radius", this.getRadius());
        data.func_74768_a("min", this.getMinY());
        data.func_74768_a("max", this.getMaxY());
        data.func_74757_a("eject", this.doEject);
        data.func_74757_a("pull", this.doPull);
        data.func_74757_a("silkTouch", this.getSilkTouch());
        data.func_74757_a("inverse", this.inverse);
        data.func_74778_a("replaceStack", this.inverseReplaceTarget.getRegistryName().toString());
        data.func_74757_a("inverseReplace", this.inverseRequiresReplacement);
        if (!this.filters.isEmpty()) {
            ListNBT filterTags = new ListNBT();
            for (MinerFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundNBT()));
            }
            data.func_218657_a("filters", (INBT)filterTags);
        }
    }

    @Override
    public void configurationDataSet() {
        super.configurationDataSet();
        if (this.isRunning()) {
            this.stop();
            this.reset();
            this.start();
        }
    }

    @Override
    protected void loadGeneralPersistentData(CompoundNBT data) {
        super.loadGeneralPersistentData(data);
        this.setRadius(Math.min(data.func_74762_e("radius"), MekanismConfig.general.minerMaxRadius.get()));
        NBTUtils.setIntIfPresent(data, "min", this::setMinY);
        NBTUtils.setIntIfPresent(data, "max", this::setMaxY);
        this.doEject = data.func_74767_n("eject");
        this.doPull = data.func_74767_n("pull");
        NBTUtils.setBooleanIfPresent(data, "silkTouch", this::setSilkTouch);
        this.inverse = data.func_74767_n("inverse");
        this.inverseReplaceTarget = NBTUtils.readRegistryEntry(data, "replaceStack", ForgeRegistries.ITEMS, Items.field_190931_a);
        this.inverseRequiresReplacement = data.func_74767_n("inverseReplace");
        this.filters.clear();
        if (data.func_150297_b("filters", 9)) {
            ListNBT tagList = data.func_150295_c("filters", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.func_150305_b(i));
                if (!(filter instanceof MinerFilter)) continue;
                this.filters.add((MinerFilter)filter);
            }
        }
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        ItemDataUtils.setInt(itemStack, "radius", this.getRadius());
        ItemDataUtils.setInt(itemStack, "min", this.getMinY());
        ItemDataUtils.setInt(itemStack, "max", this.getMaxY());
        ItemDataUtils.setBoolean(itemStack, "eject", this.doEject);
        ItemDataUtils.setBoolean(itemStack, "pull", this.doPull);
        ItemDataUtils.setBoolean(itemStack, "silkTouch", this.getSilkTouch());
        ItemDataUtils.setBoolean(itemStack, "inverse", this.inverse);
        ItemDataUtils.setString(itemStack, "replaceStack", this.inverseReplaceTarget.getRegistryName().toString());
        ItemDataUtils.setBoolean(itemStack, "inverseReplace", this.inverseRequiresReplacement);
        if (!this.filters.isEmpty()) {
            ListNBT filterTags = new ListNBT();
            for (MinerFilter<?> filter : this.filters) {
                filterTags.add((Object)filter.write(new CompoundNBT()));
            }
            ItemDataUtils.setList(itemStack, "filters", filterTags);
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "radius", 3)) {
            this.setRadius(Math.min(ItemDataUtils.getInt(itemStack, "radius"), MekanismConfig.general.minerMaxRadius.get()));
        }
        if (ItemDataUtils.hasData(itemStack, "min", 3)) {
            this.setMinY(ItemDataUtils.getInt(itemStack, "min"));
        }
        if (ItemDataUtils.hasData(itemStack, "max", 3)) {
            this.setMaxY(ItemDataUtils.getInt(itemStack, "max"));
        }
        if (ItemDataUtils.hasData(itemStack, "eject", 1)) {
            this.doEject = ItemDataUtils.getBoolean(itemStack, "eject");
        }
        if (ItemDataUtils.hasData(itemStack, "pull", 1)) {
            this.doPull = ItemDataUtils.getBoolean(itemStack, "pull");
        }
        if (ItemDataUtils.hasData(itemStack, "silkTouch", 1)) {
            this.setSilkTouch(ItemDataUtils.getBoolean(itemStack, "silkTouch"));
        }
        if (ItemDataUtils.hasData(itemStack, "inverse", 1)) {
            this.inverse = ItemDataUtils.getBoolean(itemStack, "inverse");
        }
        if (ItemDataUtils.hasData(itemStack, "replaceStack", 8)) {
            this.inverseReplaceTarget = ItemDataUtils.getRegistryEntry(itemStack, "replaceStack", ForgeRegistries.ITEMS, Items.field_190931_a);
        }
        if (ItemDataUtils.hasData(itemStack, "inverseReplace", 1)) {
            this.inverseRequiresReplacement = ItemDataUtils.getBoolean(itemStack, "inverseReplace");
        }
        if (ItemDataUtils.hasData(itemStack, "filters", 9)) {
            ListNBT tagList = ItemDataUtils.getList(itemStack, "filters");
            for (int i = 0; i < tagList.size(); ++i) {
                IFilter<?> filter = BaseFilter.readFromNBT(tagList.func_150305_b(i));
                if (!(filter instanceof MinerFilter)) continue;
                this.filters.add((MinerFilter)filter);
            }
        }
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("radius", "radius");
        remap.put("min", "min");
        remap.put("max", "max");
        remap.put("eject", "eject");
        remap.put("pull", "pull");
        remap.put("silkTouch", "silkTouch");
        remap.put("inverse", "inverse");
        remap.put("replaceStack", "replaceStack");
        remap.put("inverseReplace", "inverseReplace");
        remap.put("filters", "filters");
        return remap;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            this.delayLength = MekanismUtils.getTicks(this, MekanismConfig.general.minerTicksPerMine.get());
        }
    }

    @Override
    public List<ITextComponent> getInfo(Upgrade upgrade) {
        return UpgradeUtils.getMultScaledInfo(this, upgrade);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getOffsetCapabilityIfEnabled(@Nonnull Capability<T> capability, Direction side, @Nonnull Vector3i offset) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerManager.resolve(capability, side);
        }
        return this.getCapability(capability, side);
    }

    private boolean canAccessFromAnySide(@Nonnull Capability<?> capability) {
        return capability == Capabilities.CONFIG_CARD_CAPABILITY;
    }

    @Override
    public boolean isOffsetCapabilityDisabled(@Nonnull Capability<?> capability, Direction side, @Nonnull Vector3i offset) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.notItemPort(side, offset);
        }
        if (EnergyCompatUtils.isEnergyCapability(capability)) {
            return this.notEnergyPort(side, offset);
        }
        if (this.canEverResolve(capability) && !this.canAccessFromAnySide(capability)) {
            return this.canAccessFromAnySide(capability) || this.notItemPort(side, offset) && this.notEnergyPort(side, offset);
        }
        return false;
    }

    private boolean notItemPort(Direction side, Vector3i offset) {
        if (offset.equals((Object)new Vector3i(0, 1, 0))) {
            return side != Direction.UP;
        }
        Direction back = this.getOppositeDirection();
        if (offset.equals((Object)new Vector3i(back.func_82601_c(), 1, back.func_82599_e()))) {
            return side != back;
        }
        return true;
    }

    private boolean notEnergyPort(Direction side, Vector3i offset) {
        if (offset.equals((Object)Vector3i.field_177959_e)) {
            return side != Direction.DOWN;
        }
        Direction left = this.getLeftSide();
        if (offset.equals((Object)new Vector3i(left.func_82601_c(), 0, left.func_82599_e()))) {
            return side != left;
        }
        Direction right = left.func_176734_d();
        if (offset.equals((Object)new Vector3i(right.func_82601_c(), 0, right.func_82599_e()))) {
            return side != right;
        }
        return true;
    }

    public TileComponentChunkLoader<TileEntityDigitalMiner> getChunkLoader() {
        return this.chunkLoaderComponent;
    }

    private void updateTargetChunk(@Nullable ChunkPos target) {
        if (!Objects.equals(this.targetChunk, target)) {
            this.targetChunk = target;
            this.getChunkLoader().refreshChunkTickets();
        }
    }

    @Override
    public Set<ChunkPos> getChunkSet() {
        ChunkPos minerChunk = new ChunkPos(this.field_174879_c);
        if (this.targetChunk != null && this.field_174879_c.func_177958_n() - this.radius >> 4 <= this.targetChunk.field_77276_a && this.targetChunk.field_77276_a <= this.field_174879_c.func_177958_n() + this.radius >> 4 && this.field_174879_c.func_177952_p() - this.radius >> 4 <= this.targetChunk.field_77275_b && this.targetChunk.field_77275_b <= this.field_174879_c.func_177952_p() + this.radius >> 4) {
            ObjectArraySet chunks = new ObjectArraySet(2);
            chunks.add(minerChunk);
            chunks.add(this.targetChunk);
            return chunks;
        }
        return Collections.singleton(minerChunk);
    }

    @Override
    @ComputerMethod
    public HashList<MinerFilter<?>> getFilters() {
        return this.filters;
    }

    public MinerEnergyContainer getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod
    public int getToMine() {
        return !this.isRemote() && this.searcher.state == ThreadMinerSearch.State.SEARCHING ? this.searcher.found : this.cachedToMine;
    }

    @ComputerMethod
    public boolean isRunning() {
        return this.running;
    }

    @ComputerMethod(nameOverride="getAutoEject")
    public boolean getDoEject() {
        return this.doEject;
    }

    @ComputerMethod(nameOverride="getAutoPull")
    public boolean getDoPull() {
        return this.doPull;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        this.addConfigContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getDoEject, value -> {
            this.doEject = value;
        }));
        container.track(SyncableBoolean.create(this::getDoPull, value -> {
            this.doPull = value;
        }));
        container.track(SyncableBoolean.create(this::isRunning, value -> {
            this.running = value;
        }));
        container.track(SyncableBoolean.create(this::getSilkTouch, this::setSilkTouch));
        container.track(SyncableEnum.create(ThreadMinerSearch.State::byIndexStatic, ThreadMinerSearch.State.IDLE, () -> this.searcher.state, value -> {
            this.searcher.state = value;
        }));
        container.track(SyncableInt.create(this::getToMine, value -> {
            this.cachedToMine = value;
        }));
        container.track(SyncableItemStack.create(() -> this.missingStack, value -> {
            this.missingStack = value;
        }));
    }

    public void addConfigContainerTrackers(MekanismContainer container) {
        container.track(SyncableInt.create(this::getRadius, this::setRadius));
        container.track(SyncableInt.create(this::getMinY, this::setMinY));
        container.track(SyncableInt.create(this::getMaxY, this::setMaxY));
        container.track(SyncableBoolean.create(this::getInverse, value -> {
            this.inverse = value;
        }));
        container.track(SyncableBoolean.create(this::getInverseRequiresReplacement, value -> {
            this.inverseRequiresReplacement = value;
        }));
        container.track(SyncableRegistryEntry.create(this::getInverseReplaceTarget, value -> {
            this.inverseReplaceTarget = value;
        }));
        container.track(SyncableFilterList.create(this::getFilters, value -> {
            this.filters = value instanceof HashList ? (HashList)value : new HashList(value);
        }));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74768_a("radius", this.getRadius());
        updateTag.func_74768_a("min", this.getMinY());
        updateTag.func_74768_a("max", this.getMaxY());
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setIntIfPresent(tag, "radius", this::setRadius);
        NBTUtils.setIntIfPresent(tag, "min", this::setMinY);
        NBTUtils.setIntIfPresent(tag, "max", this::setMaxY);
    }

    private List<ItemStack> getDrops(BlockState state, BlockPos pos) {
        if (state.isAir((IBlockReader)this.getWorldNN(), pos)) {
            return Collections.emptyList();
        }
        ItemStack stack = MekanismItems.ATOMIC_DISASSEMBLER.getItemStack();
        if (this.getSilkTouch()) {
            stack.func_77966_a(Enchantments.field_185306_r, 1);
        }
        return MekFakePlayer.withFakePlayer((ServerWorld)this.getWorldNN(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), fakePlayer -> {
            fakePlayer.setEmulatingUUID(this.getOwnerUUID());
            LootContext.Builder lootContextBuilder = new LootContext.Builder((ServerWorld)this.getWorldNN()).func_216023_a(this.getWorldNN().field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)stack).func_216021_b(LootParameters.field_216281_a, (Object)fakePlayer).func_216021_b(LootParameters.field_216288_h, (Object)WorldUtils.getTileEntity((IBlockReader)this.getWorldNN(), pos));
            return state.func_215693_a(lootContextBuilder);
        });
    }

    @ComputerMethod
    private FloatingLong getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
    }

    @ComputerMethod
    private int getSlotCount() {
        return this.mainSlots.size();
    }

    @ComputerMethod
    private ItemStack getItemInSlot(int slot) throws ComputerException {
        int slots = this.getSlotCount();
        if (slot < 0 || slot >= slots) {
            throw new ComputerException("Slot: '%d' is out of bounds, as this digital miner only has '%d' slots (zero indexed).", slot, slots);
        }
        return this.mainSlots.get(slot).getStack();
    }

    @ComputerMethod
    private ThreadMinerSearch.State getState() {
        return this.searcher.state;
    }

    @ComputerMethod
    private void setAutoEject(boolean eject) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.doEject != eject) {
            this.toggleAutoEject();
        }
    }

    @ComputerMethod
    private void setAutoPull(boolean pull) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.doPull != pull) {
            this.toggleAutoPull();
        }
    }

    @ComputerMethod(nameOverride="setSilkTouch")
    private void computerSetSilkTouch(boolean silk) throws ComputerException {
        this.validateSecurityIsPublic();
        this.setSilkTouch(silk);
    }

    @ComputerMethod(nameOverride="start")
    private void computerStart() throws ComputerException {
        this.validateSecurityIsPublic();
        this.start();
    }

    @ComputerMethod(nameOverride="stop")
    private void computerStop() throws ComputerException {
        this.validateSecurityIsPublic();
        this.stop();
    }

    @ComputerMethod(nameOverride="reset")
    private void computerReset() throws ComputerException {
        this.validateSecurityIsPublic();
        this.reset();
    }

    @ComputerMethod
    private int getMaxRadius() {
        return MekanismConfig.general.minerMaxRadius.get();
    }

    private void validateCanChangeConfiguration() throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.searcher.state != ThreadMinerSearch.State.IDLE) {
            throw new ComputerException("Miner must be stopped and reset before its targeting configuration is changed.");
        }
    }

    @ComputerMethod(nameOverride="setRadius")
    private void computerSetRadius(int radius) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (radius < 0 || radius > MekanismConfig.general.minerMaxRadius.get()) {
            throw new ComputerException("Radius '%d' is out of range must be between 0 and %d. (Inclusive)", radius, MekanismConfig.general.minerMaxRadius.get());
        }
        this.setRadiusFromPacket(radius);
    }

    @ComputerMethod(nameOverride="setMinY")
    private void computerSetMinY(int minY) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (minY < 0 || minY > this.getMaxY()) {
            throw new ComputerException("Min Y '%d' is out of range must be between 0 and %d. (Inclusive)", minY, this.getMaxY());
        }
        this.setMinYFromPacket(minY);
    }

    @ComputerMethod(nameOverride="setMaxY")
    private void computerSetMaxY(int maxY) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.field_145850_b != null) {
            int max = this.field_145850_b.func_217301_I() - 1;
            if (maxY < this.getMinY() || maxY > max) {
                throw new ComputerException("Max Y '%d' is out of range must be between %d and %d. (Inclusive)", maxY, this.getMinY(), max);
            }
            this.setMaxYFromPacket(maxY);
        }
    }

    @ComputerMethod
    private void setInverseMode(boolean enabled) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.inverse != enabled) {
            this.toggleInverse();
        }
    }

    @ComputerMethod
    private void setInverseModeRequiresReplacement(boolean requiresReplacement) throws ComputerException {
        this.validateCanChangeConfiguration();
        if (this.inverseRequiresReplacement != requiresReplacement) {
            this.toggleInverseRequiresReplacement();
        }
    }

    @ComputerMethod
    private void setInverseModeReplaceTarget(Item target) throws ComputerException {
        this.validateCanChangeConfiguration();
        this.setInverseReplaceTarget(target);
    }

    @ComputerMethod
    private void clearInverseModeReplaceTarget() throws ComputerException {
        this.setInverseModeReplaceTarget(Items.field_190931_a);
    }

    @ComputerMethod
    private boolean addFilter(MinerFilter<?> filter) throws ComputerException {
        this.validateCanChangeConfiguration();
        return this.filters.add(filter);
    }

    @ComputerMethod
    private boolean removeFilter(MinerFilter<?> filter) throws ComputerException {
        this.validateCanChangeConfiguration();
        return this.filters.remove(filter);
    }

    private static class ItemCount {
        private final ItemStack stack;
        private int count;

        public ItemCount(ItemStack stack, int count) {
            this.stack = stack;
            this.count = count;
        }
    }
}

