/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ItemStackToGasRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.chemical.ItemStackToChemicalCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.NutritionalLiquifierIRecipe;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismGases;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityNutritionalLiquifier
extends TileEntityProgressMachine<ItemStackToGasRecipe> {
    public static final int MAX_GAS = 10000;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"})
    public IGasTank gasTank;
    private final IOutputHandler<@NonNull GasStack> outputHandler;
    private final IInputHandler<@NonNull ItemStack> inputHandler;
    private MachineEnergyContainer<TileEntityNutritionalLiquifier> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInput"})
    private InputInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"})
    private GasInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;
    @Nullable
    private HashedItem lastPasteItem;
    private float lastPasteScale;

    public TileEntityNutritionalLiquifier() {
        super(MekanismBlocks.NUTRITIONAL_LIQUIFIER, 100);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.ENERGY);
        this.configComponent.setupItemIOConfig(this.inputSlot, this.outputSlot, this.energySlot);
        this.configComponent.setupOutputConfig(TransmissionType.GAS, this.gasTank, RelativeSide.RIGHT);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.GAS);
        this.inputHandler = InputHelper.getInputHandler(this.inputSlot);
        this.outputHandler = OutputHelper.getOutputHandler(this.gasTank);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        this.gasTank = ChemicalTankBuilder.GAS.output(10000L, this);
        builder.addTank(this.gasTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.inputSlot = InputInventorySlot.at(stack -> {
            Item item = stack.func_77973_b();
            if (item.func_219971_r()) {
                Food food = item.func_219967_s();
                return food != null && food.func_221466_a() > 0;
            }
            return false;
        }, this.recipeCacheLookupMonitor, 26, 36);
        builder.addSlot(this.inputSlot);
        this.outputSlot = GasInventorySlot.drain(this.gasTank, this, 155, 25);
        builder.addSlot(this.outputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityNutritionalLiquifier)this).func_145831_w(), this, 155, 5);
        builder.addSlot(this.energySlot);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.outputSlot.drainTank();
        this.recipeCacheLookupMonitor.updateAndProcess();
        boolean needsPacket = false;
        float pasteScale = MekanismUtils.getScale(this.lastPasteScale, this.gasTank);
        if (pasteScale != this.lastPasteScale) {
            this.lastPasteScale = pasteScale;
            needsPacket = true;
        }
        if (this.inputSlot.isEmpty()) {
            if (this.lastPasteItem != null) {
                this.lastPasteItem = null;
                needsPacket = true;
            }
        } else {
            HashedItem item = HashedItem.raw(this.inputSlot.getStack());
            if (!item.equals(this.lastPasteItem)) {
                this.lastPasteItem = HashedItem.create(item.getStack());
                needsPacket = true;
            }
        }
        if (needsPacket) {
            this.sendUpdatePacket();
        }
    }

    @Override
    @Nonnull
    public MekanismRecipeType<ItemStackToGasRecipe, IInputRecipeCache> getRecipeType() {
        return null;
    }

    @Override
    @Nullable
    public ItemStackToGasRecipe getRecipe(int cacheIndex) {
        ItemStack stack = this.inputHandler.getInput();
        if (stack.func_190926_b() || !stack.func_77973_b().func_219971_r()) {
            return null;
        }
        Food food = stack.func_77973_b().func_219967_s();
        if (food == null || food.func_221466_a() == 0) {
            return null;
        }
        return new NutritionalLiquifierIRecipe(stack.func_77973_b(), ItemStackIngredient.from((IItemProvider)stack.func_77973_b()), MekanismGases.NUTRITIONAL_PASTE.getStack((long)food.func_221466_a() * 50L));
    }

    @Override
    @Nonnull
    public CachedRecipe<ItemStackToGasRecipe> createNewCachedRecipe(@Nonnull ItemStackToGasRecipe recipe, int cacheIndex) {
        return new ItemStackToChemicalCachedRecipe(recipe, this.inputHandler, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(this::setOperatingTicks);
    }

    public MachineEnergyContainer<TileEntityNutritionalLiquifier> getEnergyContainer() {
        return this.energyContainer;
    }

    public ItemStack getRenderStack() {
        if (this.lastPasteItem == null) {
            return ItemStack.field_190927_a;
        }
        return this.lastPasteItem.getStack();
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_218657_a("gas", (INBT)this.gasTank.serializeNBT());
        CompoundNBT item = new CompoundNBT();
        if (this.lastPasteItem != null) {
            item.func_74778_a("id", this.lastPasteItem.getStack().func_77973_b().getRegistryName().toString());
            CompoundNBT tag = this.lastPasteItem.getStack().func_77978_p();
            if (tag != null) {
                item.func_218657_a("tag", (INBT)tag.func_74737_b());
            }
        }
        updateTag.func_218657_a("Item", (INBT)item);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setCompoundIfPresent(tag, "gas", nbt -> this.gasTank.deserializeNBT((CompoundNBT)nbt));
        NBTUtils.setCompoundIfPresent(tag, "Item", nbt -> {
            Item item;
            ResourceLocation id;
            if (nbt.isEmpty()) {
                this.lastPasteItem = null;
            } else if (nbt.func_150297_b("id", 8) && (id = ResourceLocation.func_208304_a((String)nbt.func_74779_i("id"))) != null && (item = (Item)ForgeRegistries.ITEMS.getValue(id)) != null && item != Items.field_190931_a) {
                ItemStack stack = new ItemStack((IItemProvider)item);
                if (nbt.func_150297_b("tag", 10)) {
                    stack.func_77982_d(nbt.func_74775_l("tag"));
                }
                this.lastPasteItem = HashedItem.raw(stack);
            }
        });
    }

    @ComputerMethod
    private FloatingLong getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
    }
}

