/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.annotations.NonNull;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.SawmillCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.upgrade.SawmillUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;

public class TileEntityPrecisionSawmill
extends TileEntityProgressMachine<SawmillRecipe>
implements ISingleRecipeLookupHandler.ItemRecipeLookupHandler<SawmillRecipe> {
    private final IOutputHandler<@NonNull SawmillRecipe.ChanceOutput> outputHandler;
    private final IInputHandler<@NonNull ItemStack> inputHandler;
    private MachineEnergyContainer<TileEntityPrecisionSawmill> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInput"})
    private InputInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutput"})
    private OutputInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getSecondaryOutput"})
    private OutputInventorySlot secondaryOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityPrecisionSawmill() {
        super(MekanismBlocks.PRECISION_SAWMILL, 200);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.configComponent.setupItemIOConfig(Collections.singletonList(this.inputSlot), Arrays.asList(this.outputSlot, this.secondaryOutputSlot), this.energySlot, false);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM);
        this.inputHandler = InputHelper.getInputHandler(this.inputSlot);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputSlot, (IInventorySlot)this.secondaryOutputSlot);
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.inputSlot = InputInventorySlot.at(this::containsRecipe, this.recipeCacheLookupMonitor, 56, 17);
        builder.addSlot(this.inputSlot);
        this.outputSlot = OutputInventorySlot.at(this, 116, 35);
        builder.addSlot(this.outputSlot);
        this.secondaryOutputSlot = OutputInventorySlot.at(this, 132, 35);
        builder.addSlot(this.secondaryOutputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityPrecisionSawmill)this).func_145831_w(), this, 56, 53);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    @Override
    @Nonnull
    public MekanismRecipeType<SawmillRecipe, InputRecipeCache.SingleItem<SawmillRecipe>> getRecipeType() {
        return MekanismRecipeType.SAWING;
    }

    @Override
    @Nullable
    public SawmillRecipe getRecipe(int cacheIndex) {
        return (SawmillRecipe)this.findFirstRecipe(this.inputHandler);
    }

    @Override
    @Nonnull
    public CachedRecipe<SawmillRecipe> createNewCachedRecipe(@Nonnull SawmillRecipe recipe, int cacheIndex) {
        return new SawmillCachedRecipe(recipe, this.inputHandler, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(this::setOperatingTicks);
    }

    @Override
    @Nonnull
    public SawmillUpgradeData getUpgradeData() {
        return new SawmillUpgradeData(this.redstone, this.getControlType(), this.getEnergyContainer(), this.getOperatingTicks(), this.energySlot, this.inputSlot, this.outputSlot, this.secondaryOutputSlot, this.getComponents());
    }

    public MachineEnergyContainer<TileEntityPrecisionSawmill> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public boolean isConfigurationDataCompatible(TileEntityType<?> tileType) {
        return super.isConfigurationDataCompatible(tileType) || MekanismUtils.isSameTypeFactory(this.getBlockType(), tileType);
    }

    @ComputerMethod
    private FloatingLong getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
    }
}

