/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.RelativeSide;
import mekanism.api.heat.HeatAPI;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.energy.ResistiveHeaterEnergyContainer;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHelper;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;

public class TileEntityResistiveHeater
extends TileEntityMekanism {
    private float soundScale = 1.0f;
    private double lastEnvironmentLoss;
    private ResistiveHeaterEnergyContainer energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerHeatCapacitorWrapper.class, methodNames={"getTemperature"})
    private BasicHeatCapacitor heatCapacitor;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityResistiveHeater() {
        super(MekanismBlocks.RESISTIVE_HEATER);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = ResistiveHeaterEnergyContainer.input(this);
        builder.addContainer(this.energyContainer, RelativeSide.LEFT, RelativeSide.RIGHT);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors(CachedAmbientTemperature ambientTemperature) {
        HeatCapacitorHelper builder = HeatCapacitorHelper.forSide(this::getDirection);
        this.heatCapacitor = BasicHeatCapacitor.create(100.0, 5.0, 100.0, ambientTemperature, this);
        builder.addCapacitor(this.heatCapacitor);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityResistiveHeater)this).func_145831_w(), this, 15, 35);
        builder.addSlot(this.energySlot);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        FloatingLong toUse = FloatingLong.ZERO;
        if (MekanismUtils.canFunction(this) && !(toUse = this.energyContainer.extract(this.energyContainer.getEnergyPerTick(), Action.SIMULATE, AutomationType.INTERNAL)).isZero()) {
            this.heatCapacitor.handleHeat(toUse.multiply(MekanismConfig.general.resistiveHeaterEfficiency.get()).doubleValue());
            this.energyContainer.extract(toUse, Action.EXECUTE, AutomationType.INTERNAL);
        }
        this.setActive(!toUse.isZero());
        HeatAPI.HeatTransfer transfer = this.simulate();
        this.lastEnvironmentLoss = transfer.getEnvironmentTransfer();
        float newSoundScale = toUse.divide(100000L).floatValue();
        if ((double)Math.abs(newSoundScale - this.soundScale) > 0.01) {
            this.soundScale = newSoundScale;
            this.sendUpdatePacket();
        }
    }

    @ComputerMethod(nameOverride="getEnvironmentalLoss")
    public double getLastEnvironmentLoss() {
        return this.lastEnvironmentLoss;
    }

    public void setEnergyUsageFromPacket(FloatingLong floatingLong) {
        this.energyContainer.updateEnergyUsage(floatingLong);
        this.markDirty(false);
    }

    @Override
    public float getVolume() {
        return (float)Math.sqrt(this.soundScale);
    }

    public MachineEnergyContainer<TileEntityResistiveHeater> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public CompoundNBT getConfigurationData(PlayerEntity player) {
        CompoundNBT data = super.getConfigurationData(player);
        data.func_74778_a("energyUsage", this.energyContainer.getEnergyPerTick().toString());
        return data;
    }

    @Override
    public void setConfigurationData(PlayerEntity player, CompoundNBT data) {
        super.setConfigurationData(player, data);
        NBTUtils.setFloatingLongIfPresent(data, "energyUsage", this.energyContainer::updateEnergyUsage);
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableDouble.create(this::getLastEnvironmentLoss, value -> {
            this.lastEnvironmentLoss = value;
        }));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74776_a("soundScale", this.soundScale);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        NBTUtils.setFloatIfPresent(tag, "soundScale", value -> {
            this.soundScale = value;
        });
    }

    @ComputerMethod
    private FloatingLong getEnergyUsage() {
        return this.energyContainer.getEnergyPerTick();
    }

    @ComputerMethod
    private void setEnergyUsage(FloatingLong usage) throws ComputerException {
        this.validateSecurityIsPublic();
        this.setEnergyUsageFromPacket(usage);
    }
}

