/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.inventory.AutomationType;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.chemical.ChemicalToChemicalCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class TileEntitySolarNeutronActivator
extends TileEntityRecipeMachine<GasToGasRecipe>
implements IBoundingBlock,
ISingleRecipeLookupHandler.ChemicalRecipeLookupHandler<Gas, GasStack, GasToGasRecipe> {
    public static final long MAX_GAS = 10000L;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getInput", "getInputCapacity", "getInputNeeded", "getInputFilledPercentage"})
    public IGasTank inputTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"})
    public IGasTank outputTank;
    @SyntheticComputerMethod(getter="getPeakProductionRate")
    private float peakProductionRate;
    @SyntheticComputerMethod(getter="getProductionRate")
    private float productionRate;
    private boolean settingsChecked;
    private boolean needsRainCheck;
    private final IOutputHandler<@NonNull GasStack> outputHandler;
    private final IInputHandler<@NonNull GasStack> inputHandler;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"})
    private GasInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"})
    private GasInventorySlot outputSlot;

    public TileEntitySolarNeutronActivator() {
        super(MekanismBlocks.SOLAR_NEUTRON_ACTIVATOR);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.GAS);
        this.configComponent.setupIOConfig(TransmissionType.ITEM, (Object)this.inputSlot, this.outputSlot, RelativeSide.FRONT);
        this.configComponent.setupIOConfig(TransmissionType.GAS, this.inputTank, this.outputTank, RelativeSide.FRONT, false, true).setEjecting(true);
        this.configComponent.addDisabledSides(RelativeSide.TOP);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM, TransmissionType.GAS).setCanTankEject(tank -> tank != this.inputTank);
        this.inputHandler = InputHelper.getInputHandler(this.inputTank);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputTank);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        this.inputTank = ChemicalTankBuilder.GAS.create(10000L, (type, automationType) -> automationType != AutomationType.EXTERNAL || this.outputTank.isEmpty() && type.has(GasAttributes.Radiation.class), ChemicalTankBuilder.GAS.alwaysTrueBi, this::containsRecipe, ChemicalAttributeValidator.ALWAYS_ALLOW, (IContentsListener)this.recipeCacheLookupMonitor);
        builder.addTank(this.inputTank);
        this.outputTank = ChemicalTankBuilder.GAS.output(10000L, this);
        builder.addTank(this.outputTank);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.inputSlot = GasInventorySlot.fill(this.inputTank, this, 5, 56);
        builder.addSlot(this.inputSlot);
        this.outputSlot = GasInventorySlot.drain(this.outputTank, this, 155, 56);
        builder.addSlot(this.outputSlot);
        this.inputSlot.setSlotType(ContainerSlotType.INPUT);
        this.inputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.outputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    private void recheckSettings() {
        World world = this.func_145831_w();
        if (world == null) {
            return;
        }
        Biome b = world.func_225523_d_().func_226836_a_(this.func_174877_v());
        this.needsRainCheck = b.func_201851_b() != Biome.RainType.NONE;
        float tempEff = 0.3f * (0.8f - b.func_225486_c(this.func_174877_v()));
        float humidityEff = this.needsRainCheck ? -0.3f * b.func_76727_i() : 0.0f;
        this.peakProductionRate = (float)MekanismConfig.general.maxSolarNeutronActivatorRate.get() * (1.0f + tempEff + humidityEff);
        this.settingsChecked = true;
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (!this.settingsChecked) {
            this.recheckSettings();
        }
        this.inputSlot.fillTank();
        this.outputSlot.drainTank();
        this.productionRate = this.recalculateProductionRate();
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    @Override
    @Nonnull
    public MekanismRecipeType<GasToGasRecipe, InputRecipeCache.SingleChemical<Gas, GasStack, GasToGasRecipe>> getRecipeType() {
        return MekanismRecipeType.ACTIVATING;
    }

    @Override
    @Nullable
    public GasToGasRecipe getRecipe(int cacheIndex) {
        return (GasToGasRecipe)this.findFirstRecipe(this.inputHandler);
    }

    private boolean canFunction() {
        return MekanismUtils.canFunction(this) && WorldUtils.canSeeSun(this.field_145850_b, this.field_174879_c.func_177984_a());
    }

    private float recalculateProductionRate() {
        World world = this.func_145831_w();
        if (world == null || !this.canFunction()) {
            return 0.0f;
        }
        float brightness = WorldUtils.getSunBrightness(world, 1.0f);
        float production = this.peakProductionRate * brightness;
        if (this.needsRainCheck && (world.func_72896_J() || world.func_72911_I())) {
            production *= 0.2f;
        }
        return production;
    }

    @Override
    @Nonnull
    public CachedRecipe<GasToGasRecipe> createNewCachedRecipe(@Nonnull GasToGasRecipe recipe, int cacheIndex) {
        return new ChemicalToChemicalCachedRecipe(recipe, this.inputHandler, this.outputHandler).setCanHolderFunction(this::canFunction).setActive(this::setActive).setOnFinish(() -> this.markDirty(false)).setRequiredTicks(() -> this.productionRate > 0.0f && this.productionRate < 1.0f ? (int)Math.ceil(1.0f / this.productionRate) : 1).setPostProcessOperations(currentMax -> {
            if (currentMax <= 0) {
                return currentMax;
            }
            return Math.min(currentMax, this.productionRate > 0.0f && this.productionRate < 1.0f ? 1 : (int)this.productionRate);
        });
    }

    @Override
    public void onPlace() {
        super.onPlace();
        WorldUtils.makeBoundingBlock((IWorld)this.func_145831_w(), this.func_174877_v().func_177984_a(), this.func_174877_v());
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_217377_a(this.func_174877_v().func_177984_a(), false);
        }
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.inputTank.getStored(), this.inputTank.getCapacity());
    }
}

