/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import mekanism.api.IConfigCardAccess;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;

public abstract class TileEntityConfigurableMachine
extends TileEntityMekanism
implements ISideConfiguration,
IConfigCardAccess {
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent;

    public TileEntityConfigurableMachine(IBlockProvider blockProvider) {
        super(blockProvider);
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIG_CARD_CAPABILITY, this));
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public CompoundNBT getConfigurationData(PlayerEntity player) {
        CompoundNBT data = super.getConfigurationData(player);
        this.getConfig().write(data);
        this.getEjector().write(data);
        return data;
    }

    @Override
    public void setConfigurationData(PlayerEntity player, CompoundNBT data) {
        super.setConfigurationData(player, data);
        this.getConfig().read(data);
        this.getEjector().read(data);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.ejectorComponent != null) {
            this.ejectorComponent.tickServer();
        }
    }
}

