/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableItemStack;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.qio.TileEntityQIOComponent;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityQIORedstoneAdapter
extends TileEntityQIOComponent
implements ISustainedData {
    public static final ModelProperty<Boolean> POWERING_PROPERTY = new ModelProperty();
    private boolean prevPowering;
    private HashedItem itemType = null;
    private long count = 0L;
    private long clientStoredCount = 0L;

    public TileEntityQIORedstoneAdapter() {
        super(MekanismBlocks.QIO_REDSTONE_ADAPTER);
    }

    public boolean isPowering() {
        if (this.isRemote()) {
            return this.prevPowering;
        }
        QIOFrequency freq = this.getQIOFrequency();
        if (freq != null && this.itemType != null) {
            long stored = freq.getStored(this.itemType);
            return stored > 0L && stored >= this.count;
        }
        return false;
    }

    public void handleStackChange(ItemStack stack) {
        this.itemType = stack.func_190926_b() ? null : HashedItem.create(stack);
        this.markDirty(false);
    }

    public void handleCountChange(long count) {
        if (this.count != count) {
            this.count = count;
            this.markDirty(false);
        }
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        boolean powering = this.isPowering();
        if (powering != this.prevPowering) {
            World world = this.func_145831_w();
            if (world != null) {
                world.func_195593_d(this.func_174877_v(), this.getBlockType());
            }
            this.prevPowering = powering;
            this.sendUpdatePacket();
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(POWERING_PROPERTY, (Object)this.prevPowering).build();
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.itemType != null) {
            ItemDataUtils.setCompound(itemStack, "singleItem", this.itemType.getStack().func_77955_b(new CompoundNBT()));
        }
        ItemDataUtils.setLong(itemStack, "amount", this.count);
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "singleItem", 10)) {
            this.itemType = HashedItem.create(ItemStack.func_199557_a((CompoundNBT)ItemDataUtils.getCompound(itemStack, "singleItem")));
        }
        this.count = ItemDataUtils.getLong(itemStack, "amount");
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("singleItem", "singleItem");
        remap.put("amount", "amount");
        return remap;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        updateTag.func_74757_a("active", this.prevPowering);
        return updateTag;
    }

    @Override
    public void handleUpdateTag(BlockState state, @Nonnull CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.prevPowering = tag.func_74767_n("active");
        this.requestModelDataUpdate();
        WorldUtils.updateBlock(this.func_145831_w(), this.func_174877_v(), this.func_195044_w());
    }

    @Override
    protected void loadGeneralPersistentData(CompoundNBT data) {
        super.loadGeneralPersistentData(data);
        NBTUtils.setItemStackIfPresent(data, "singleItem", item -> {
            this.itemType = HashedItem.create(item);
        });
        NBTUtils.setLongIfPresent(data, "amount", value -> {
            this.count = value;
        });
    }

    @Override
    protected void addGeneralPersistentData(CompoundNBT data) {
        super.addGeneralPersistentData(data);
        if (this.itemType != null) {
            data.func_218657_a("singleItem", (INBT)this.itemType.getStack().func_77955_b(new CompoundNBT()));
        }
        data.func_74772_a("amount", this.count);
    }

    @ComputerMethod(nameOverride="getTargetItem")
    public ItemStack getItemType() {
        return this.itemType != null ? this.itemType.getStack() : ItemStack.field_190927_a;
    }

    @ComputerMethod(nameOverride="getTriggerAmount")
    public long getCount() {
        return this.count;
    }

    public long getStoredCount() {
        return this.clientStoredCount;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableItemStack.create(this::getItemType, value -> {
            this.itemType = value.func_190926_b() ? null : HashedItem.create(value);
        }));
        container.track(SyncableLong.create(this::getCount, value -> {
            this.count = value;
        }));
        container.track(SyncableLong.create(() -> {
            QIOFrequency freq = this.getQIOFrequency();
            return freq != null && this.itemType != null ? freq.getStored(this.itemType) : 0L;
        }, value -> {
            this.clientStoredCount = value;
        }));
    }

    @ComputerMethod
    private void clearTargetItem() throws ComputerException {
        this.validateSecurityIsPublic();
        this.handleStackChange(ItemStack.field_190927_a);
    }

    @ComputerMethod
    private void setTargetItem(ResourceLocation itemName) throws ComputerException {
        this.validateSecurityIsPublic();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemName);
        if (item == null || item == Items.field_190931_a) {
            throw new ComputerException("Target item '%s' could not be found. If you are trying to clear it consider using clearTargetItem instead.", itemName);
        }
        this.handleStackChange(new ItemStack((IItemProvider)item));
    }

    @ComputerMethod
    private void setTriggerAmount(long amount) throws ComputerException {
        this.validateSecurityIsPublic();
        if (amount < 0L) {
            throw new ComputerException("Trigger amount cannot be negative. Received: %d", amount);
        }
        this.handleCountChange(amount);
    }
}

