/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util.text;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.MekanismClient;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.common.thread.EffectiveSide;

public class OwnerDisplay
implements IHasTextComponent {
    private final PlayerEntity player;
    private final UUID ownerUUID;
    private final String ownerName;
    private final boolean colorBase;

    private OwnerDisplay(PlayerEntity player, UUID ownerUUID, String ownerName, boolean colorBase) {
        this.player = player;
        this.ownerUUID = ownerUUID;
        this.ownerName = ownerName;
        this.colorBase = colorBase;
    }

    public static OwnerDisplay of(UUID ownerUUID) {
        return OwnerDisplay.of(null, ownerUUID);
    }

    public static OwnerDisplay of(PlayerEntity player, UUID ownerUUID) {
        return OwnerDisplay.of(player, ownerUUID, null);
    }

    public static OwnerDisplay of(UUID ownerUUID, String ownerName) {
        return OwnerDisplay.of(null, ownerUUID, ownerName);
    }

    public static OwnerDisplay of(PlayerEntity player, UUID ownerUUID, String ownerName) {
        return OwnerDisplay.of(player, ownerUUID, ownerName, true);
    }

    public static OwnerDisplay of(PlayerEntity player, UUID ownerUUID, String ownerName, boolean colorBase) {
        return new OwnerDisplay(player, ownerUUID, ownerName, colorBase);
    }

    @Override
    public ITextComponent getTextComponent() {
        if (this.ownerUUID == null) {
            return MekanismLang.NO_OWNER.translateColored(EnumColor.RED, new Object[0]);
        }
        String name = OwnerDisplay.getOwnerName(this.player, this.ownerUUID, this.ownerName);
        TranslationTextComponent component = this.player == null ? MekanismLang.OWNER.translate(name) : MekanismLang.OWNER.translate(this.player.func_110124_au().equals(this.ownerUUID) ? EnumColor.BRIGHT_GREEN : EnumColor.RED, name);
        if (this.colorBase) {
            return TextComponentUtil.build(EnumColor.DARK_GRAY, component);
        }
        return component;
    }

    public static String getOwnerName(@Nullable PlayerEntity player, @Nonnull UUID ownerUUID, @Nullable String ownerName) {
        if (ownerName != null) {
            return ownerName;
        }
        if (player != null && !player.field_70170_p.field_72995_K || player == null && EffectiveSide.get().isServer()) {
            return MekanismUtils.getLastKnownUsername(ownerUUID);
        }
        String name = MekanismClient.clientUUIDMap.get(ownerUUID);
        if (name != null && player != null) {
            if (player.func_110124_au().equals(ownerUUID)) {
                name = player.func_146103_bH().getName();
                MekanismClient.clientUUIDMap.put(ownerUUID, name);
            } else {
                PlayerEntity owner = player.func_130014_f_().func_217371_b(ownerUUID);
                if (owner == null) {
                    name = "<" + ownerUUID + ">";
                } else {
                    name = owner.func_146103_bH().getName();
                    MekanismClient.clientUUIDMap.put(ownerUUID, name);
                }
            }
        }
        return name;
    }
}

