/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom.transform;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;

public class Translate2D
extends BaseTransform {
    private double mxt;
    private double myt;
    private static final long BASE_HASH;

    public static BaseTransform getInstance(double mxt, double myt) {
        if (mxt == 0.0 && myt == 0.0) {
            return IDENTITY_TRANSFORM;
        }
        return new Translate2D(mxt, myt);
    }

    public Translate2D(double tx, double ty) {
        this.mxt = tx;
        this.myt = ty;
    }

    public Translate2D(BaseTransform tx) {
        if (!tx.isTranslateOrIdentity()) {
            Translate2D.degreeError(BaseTransform.Degree.TRANSLATE_2D);
        }
        this.mxt = tx.getMxt();
        this.myt = tx.getMyt();
    }

    @Override
    public BaseTransform.Degree getDegree() {
        return BaseTransform.Degree.TRANSLATE_2D;
    }

    @Override
    public double getDeterminant() {
        return 1.0;
    }

    @Override
    public double getMxt() {
        return this.mxt;
    }

    @Override
    public double getMyt() {
        return this.myt;
    }

    @Override
    public int getType() {
        return this.mxt == 0.0 && this.myt == 0.0 ? 0 : 1;
    }

    @Override
    public boolean isIdentity() {
        return this.mxt == 0.0 && this.myt == 0.0;
    }

    @Override
    public boolean isTranslateOrIdentity() {
        return true;
    }

    @Override
    public boolean is2D() {
        return true;
    }

    @Override
    public Point2D transform(Point2D src, Point2D dst) {
        if (dst == null) {
            dst = Translate2D.makePoint(src, dst);
        }
        dst.setLocation((float)((double)src.x + this.mxt), (float)((double)src.y + this.myt));
        return dst;
    }

    @Override
    public Point2D inverseTransform(Point2D src, Point2D dst) {
        if (dst == null) {
            dst = Translate2D.makePoint(src, dst);
        }
        dst.setLocation((float)((double)src.x - this.mxt), (float)((double)src.y - this.myt));
        return dst;
    }

    @Override
    public Vec3d transform(Vec3d src, Vec3d dst) {
        if (dst == null) {
            dst = new Vec3d();
        }
        dst.x = src.x + this.mxt;
        dst.y = src.y + this.myt;
        dst.z = src.z;
        return dst;
    }

    @Override
    public Vec3d deltaTransform(Vec3d src, Vec3d dst) {
        if (dst == null) {
            dst = new Vec3d();
        }
        dst.set(src);
        return dst;
    }

    @Override
    public Vec3d inverseTransform(Vec3d src, Vec3d dst) {
        if (dst == null) {
            dst = new Vec3d();
        }
        dst.x = src.x - this.mxt;
        dst.y = src.y - this.myt;
        dst.z = src.z;
        return dst;
    }

    @Override
    public Vec3d inverseDeltaTransform(Vec3d src, Vec3d dst) {
        if (dst == null) {
            dst = new Vec3d();
        }
        dst.set(src);
        return dst;
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        float tx = (float)this.mxt;
        float ty = (float)this.myt;
        if (dstPts == srcPts) {
            if (dstOff > srcOff && dstOff < srcOff + numPts * 2) {
                System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
                srcOff = dstOff;
            }
            if (dstOff == srcOff && tx == 0.0f && ty == 0.0f) {
                return;
            }
        }
        for (int i = 0; i < numPts; ++i) {
            dstPts[dstOff++] = srcPts[srcOff++] + tx;
            dstPts[dstOff++] = srcPts[srcOff++] + ty;
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double tx = this.mxt;
        double ty = this.myt;
        if (dstPts == srcPts) {
            if (dstOff > srcOff && dstOff < srcOff + numPts * 2) {
                System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
                srcOff = dstOff;
            }
            if (dstOff == srcOff && tx == 0.0 && ty == 0.0) {
                return;
            }
        }
        for (int i = 0; i < numPts; ++i) {
            dstPts[dstOff++] = srcPts[srcOff++] + tx;
            dstPts[dstOff++] = srcPts[srcOff++] + ty;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double tx = this.mxt;
        double ty = this.myt;
        for (int i = 0; i < numPts; ++i) {
            dstPts[dstOff++] = (double)srcPts[srcOff++] + tx;
            dstPts[dstOff++] = (double)srcPts[srcOff++] + ty;
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        double tx = this.mxt;
        double ty = this.myt;
        for (int i = 0; i < numPts; ++i) {
            dstPts[dstOff++] = (float)(srcPts[srcOff++] + tx);
            dstPts[dstOff++] = (float)(srcPts[srcOff++] + ty);
        }
    }

    @Override
    public void deltaTransform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    @Override
    public void deltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    @Override
    public void inverseTransform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        float tx = (float)this.mxt;
        float ty = (float)this.myt;
        if (dstPts == srcPts) {
            if (dstOff > srcOff && dstOff < srcOff + numPts * 2) {
                System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
                srcOff = dstOff;
            }
            if (dstOff == srcOff && tx == 0.0f && ty == 0.0f) {
                return;
            }
        }
        for (int i = 0; i < numPts; ++i) {
            dstPts[dstOff++] = srcPts[srcOff++] - tx;
            dstPts[dstOff++] = srcPts[srcOff++] - ty;
        }
    }

    @Override
    public void inverseDeltaTransform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    @Override
    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        double tx = this.mxt;
        double ty = this.myt;
        if (dstPts == srcPts) {
            if (dstOff > srcOff && dstOff < srcOff + numPts * 2) {
                System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
                srcOff = dstOff;
            }
            if (dstOff == srcOff && tx == 0.0 && ty == 0.0) {
                return;
            }
        }
        for (int i = 0; i < numPts; ++i) {
            dstPts[dstOff++] = srcPts[srcOff++] - tx;
            dstPts[dstOff++] = srcPts[srcOff++] - ty;
        }
    }

    @Override
    public BaseBounds transform(BaseBounds bounds, BaseBounds result) {
        float minX = (float)((double)bounds.getMinX() + this.mxt);
        float minY = (float)((double)bounds.getMinY() + this.myt);
        float minZ = bounds.getMinZ();
        float maxX = (float)((double)bounds.getMaxX() + this.mxt);
        float maxY = (float)((double)bounds.getMaxY() + this.myt);
        float maxZ = bounds.getMaxZ();
        return result.deriveWithNewBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public void transform(Rectangle rect, Rectangle result) {
        Translate2D.transform(rect, result, this.mxt, this.myt);
    }

    @Override
    public BaseBounds inverseTransform(BaseBounds bounds, BaseBounds result) {
        float minX = (float)((double)bounds.getMinX() - this.mxt);
        float minY = (float)((double)bounds.getMinY() - this.myt);
        float minZ = bounds.getMinZ();
        float maxX = (float)((double)bounds.getMaxX() - this.mxt);
        float maxY = (float)((double)bounds.getMaxY() - this.myt);
        float maxZ = bounds.getMaxZ();
        return result.deriveWithNewBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public void inverseTransform(Rectangle rect, Rectangle result) {
        Translate2D.transform(rect, result, -this.mxt, -this.myt);
    }

    static void transform(Rectangle rect, Rectangle result, double mxt, double myt) {
        int imxt = (int)mxt;
        int imyt = (int)myt;
        if ((double)imxt == mxt && (double)imyt == myt) {
            result.setBounds(rect);
            result.translate(imxt, imyt);
        } else {
            double x1 = (double)rect.x + mxt;
            double y1 = (double)rect.y + myt;
            double x2 = Math.ceil(x1 + (double)rect.width);
            double y2 = Math.ceil(y1 + (double)rect.height);
            x1 = Math.floor(x1);
            y1 = Math.floor(y1);
            result.setBounds((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
        }
    }

    @Override
    public Shape createTransformedShape(Shape s) {
        return new Path2D(s, this);
    }

    @Override
    public void setToIdentity() {
        this.myt = 0.0;
        this.mxt = 0.0;
    }

    @Override
    public void setTransform(BaseTransform xform) {
        if (!xform.isTranslateOrIdentity()) {
            Translate2D.degreeError(BaseTransform.Degree.TRANSLATE_2D);
        }
        this.mxt = xform.getMxt();
        this.myt = xform.getMyt();
    }

    @Override
    public void invert() {
        this.mxt = -this.mxt;
        this.myt = -this.myt;
    }

    @Override
    public void restoreTransform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        if (mxx != 1.0 || myx != 0.0 || mxy != 0.0 || myy != 1.0) {
            Translate2D.degreeError(BaseTransform.Degree.TRANSLATE_2D);
        }
        this.mxt = mxt;
        this.myt = myt;
    }

    @Override
    public void restoreTransform(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        if (mxx != 1.0 || mxy != 0.0 || mxz != 0.0 || myx != 0.0 || myy != 1.0 || myz != 0.0 || mzx != 0.0 || mzy != 0.0 || mzz != 1.0 || mzt != 0.0) {
            Translate2D.degreeError(BaseTransform.Degree.TRANSLATE_2D);
        }
        this.mxt = mxt;
        this.myt = myt;
    }

    @Override
    public BaseTransform deriveWithTranslation(double mxt, double myt) {
        this.mxt += mxt;
        this.myt += myt;
        return this;
    }

    @Override
    public BaseTransform deriveWithTranslation(double mxt, double myt, double mzt) {
        if (mzt == 0.0) {
            this.mxt += mxt;
            this.myt += myt;
            return this;
        }
        Affine3D a = new Affine3D();
        a.translate(this.mxt + mxt, this.myt + myt, mzt);
        return a;
    }

    @Override
    public BaseTransform deriveWithScale(double mxx, double myy, double mzz) {
        if (mzz == 1.0) {
            if (mxx == 1.0 && myy == 1.0) {
                return this;
            }
            Affine2D a = new Affine2D();
            a.translate(this.mxt, this.myt);
            a.scale(mxx, myy);
            return a;
        }
        Affine3D a = new Affine3D();
        a.translate(this.mxt, this.myt);
        a.scale(mxx, myy, mzz);
        return a;
    }

    @Override
    public BaseTransform deriveWithRotation(double theta, double axisX, double axisY, double axisZ) {
        if (theta == 0.0) {
            return this;
        }
        if (Translate2D.almostZero(axisX) && Translate2D.almostZero(axisY)) {
            if (axisZ == 0.0) {
                return this;
            }
            Affine2D a = new Affine2D();
            a.translate(this.mxt, this.myt);
            if (axisZ > 0.0) {
                a.rotate(theta);
            } else if (axisZ < 0.0) {
                a.rotate(-theta);
            }
            return a;
        }
        Affine3D a = new Affine3D();
        a.translate(this.mxt, this.myt);
        a.rotate(theta, axisX, axisY, axisZ);
        return a;
    }

    @Override
    public BaseTransform deriveWithPreTranslation(double mxt, double myt) {
        this.mxt += mxt;
        this.myt += myt;
        return this;
    }

    @Override
    public BaseTransform deriveWithConcatenation(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        if (mxx == 1.0 && myx == 0.0 && mxy == 0.0 && myy == 1.0) {
            this.mxt += mxt;
            this.myt += myt;
            return this;
        }
        return new Affine2D(mxx, myx, mxy, myy, this.mxt + mxt, this.myt + myt);
    }

    @Override
    public BaseTransform deriveWithConcatenation(double mxx, double mxy, double mxz, double mxt, double myx, double myy, double myz, double myt, double mzx, double mzy, double mzz, double mzt) {
        if (mxz == 0.0 && myz == 0.0 && mzx == 0.0 && mzy == 0.0 && mzz == 1.0 && mzt == 0.0) {
            return this.deriveWithConcatenation(mxx, myx, mxy, myy, mxt, myt);
        }
        return new Affine3D(mxx, mxy, mxz, mxt + this.mxt, myx, myy, myz, myt + this.myt, mzx, mzy, mzz, mzt);
    }

    @Override
    public BaseTransform deriveWithConcatenation(BaseTransform tx) {
        if (tx.isTranslateOrIdentity()) {
            this.mxt += tx.getMxt();
            this.myt += tx.getMyt();
            return this;
        }
        if (tx.is2D()) {
            return Translate2D.getInstance(tx.getMxx(), tx.getMyx(), tx.getMxy(), tx.getMyy(), this.mxt + tx.getMxt(), this.myt + tx.getMyt());
        }
        Affine3D t3d = new Affine3D(tx);
        t3d.preTranslate(this.mxt, this.myt, 0.0);
        return t3d;
    }

    @Override
    public BaseTransform deriveWithPreConcatenation(BaseTransform tx) {
        if (tx.isTranslateOrIdentity()) {
            this.mxt += tx.getMxt();
            this.myt += tx.getMyt();
            return this;
        }
        if (tx.is2D()) {
            Affine2D t2d = new Affine2D(tx);
            t2d.translate(this.mxt, this.myt);
            return t2d;
        }
        Affine3D t3d = new Affine3D(tx);
        t3d.translate(this.mxt, this.myt, 0.0);
        return t3d;
    }

    @Override
    public BaseTransform deriveWithNewTransform(BaseTransform tx) {
        if (tx.isTranslateOrIdentity()) {
            this.mxt = tx.getMxt();
            this.myt = tx.getMyt();
            return this;
        }
        return Translate2D.getInstance(tx);
    }

    @Override
    public BaseTransform createInverse() {
        if (this.isIdentity()) {
            return IDENTITY_TRANSFORM;
        }
        return new Translate2D(-this.mxt, -this.myt);
    }

    private static double _matround(double matval) {
        return Math.rint(matval * 1.0E15) / 1.0E15;
    }

    @Override
    public String toString() {
        return "Translate2D[" + Translate2D._matround(this.mxt) + ", " + Translate2D._matround(this.myt) + "]";
    }

    @Override
    public BaseTransform copy() {
        return new Translate2D(this.mxt, this.myt);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BaseTransform) {
            BaseTransform tx = (BaseTransform)obj;
            return tx.isTranslateOrIdentity() && tx.getMxt() == this.mxt && tx.getMyt() == this.myt;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.isIdentity()) {
            return 0;
        }
        long bits = BASE_HASH;
        bits = bits * 31L + Double.doubleToLongBits(this.getMyt());
        bits = bits * 31L + Double.doubleToLongBits(this.getMxt());
        return (int)bits ^ (int)(bits >> 32);
    }

    static {
        long bits = 0L;
        bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMzz());
        bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMzy());
        bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMzx());
        bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMyz());
        bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMxz());
        bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMyy());
        bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMyx());
        bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMxy());
        bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMxx());
        BASE_HASH = bits = bits * 31L + Double.doubleToLongBits(IDENTITY_TRANSFORM.getMzt());
    }
}

