/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.tk.RenderJob;
import com.sun.javafx.tk.Toolkit;
import com.sun.webkit.Invoker;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PrismInvoker
extends Invoker {
    private static final Logger log = Logger.getLogger(PrismInvoker.class.getName());

    @Override
    protected boolean lock(ReentrantLock lock) {
        return false;
    }

    @Override
    protected boolean unlock(ReentrantLock lock) {
        return false;
    }

    @Override
    protected boolean isEventThread() {
        return PrismInvoker.isEventThreadPrivate();
    }

    private static boolean isEventThreadPrivate() {
        return Toolkit.getToolkit().isFxUserThread();
    }

    @Override
    public void checkEventThread() {
        Toolkit.getToolkit().checkFxUserThread();
    }

    @Override
    public void invokeOnEventThread(Runnable r) {
        if (this.isEventThread()) {
            r.run();
        } else {
            PlatformImpl.runLater(r);
        }
    }

    @Override
    public void postOnEventThread(Runnable r) {
        PlatformImpl.runLater(r);
    }

    static void invokeOnRenderThread(Runnable r) {
        Toolkit.getToolkit().addRenderJob(new RenderJob(r));
    }

    static void runOnRenderThread(Runnable r) {
        if (Thread.currentThread().getName().startsWith("QuantumRenderer")) {
            r.run();
        } else {
            FutureTask<Object> f = new FutureTask<Object>(r, null);
            Toolkit.getToolkit().addRenderJob(new RenderJob(f));
            try {
                f.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                log.log(Level.SEVERE, "RenderJob error", ex);
            }
        }
    }
}

