/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.LockableResource;
import com.sun.scenario.effect.impl.Renderer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;

public class FloatMap {
    private final int width;
    private final int height;
    private final FloatBuffer buf;
    private boolean cacheValid;
    private Map<FilterContext, Entry> cache;

    public FloatMap(int width, int height) {
        if (width <= 0 || width > 4096 || height <= 0 || height > 4096) {
            throw new IllegalArgumentException("Width and height must be in the range [1, 4096]");
        }
        this.width = width;
        this.height = height;
        int size = width * height * 4;
        this.buf = FloatBuffer.wrap(new float[size]);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float[] getData() {
        return this.buf.array();
    }

    public FloatBuffer getBuffer() {
        return this.buf;
    }

    public float getSample(int x, int y, int band) {
        return this.buf.get((x + y * this.width) * 4 + band);
    }

    public void setSample(int x, int y, int band, float sample) {
        this.buf.put((x + y * this.width) * 4 + band, sample);
        this.cacheValid = false;
    }

    public void setSamples(int x, int y, float s0) {
        int index = (x + y * this.width) * 4;
        this.buf.put(index + 0, s0);
        this.cacheValid = false;
    }

    public void setSamples(int x, int y, float s0, float s1) {
        int index = (x + y * this.width) * 4;
        this.buf.put(index + 0, s0);
        this.buf.put(index + 1, s1);
        this.cacheValid = false;
    }

    public void setSamples(int x, int y, float s0, float s1, float s2) {
        int index = (x + y * this.width) * 4;
        this.buf.put(index + 0, s0);
        this.buf.put(index + 1, s1);
        this.buf.put(index + 2, s2);
        this.cacheValid = false;
    }

    public void setSamples(int x, int y, float s0, float s1, float s2, float s3) {
        int index = (x + y * this.width) * 4;
        this.buf.put(index + 0, s0);
        this.buf.put(index + 1, s1);
        this.buf.put(index + 2, s2);
        this.buf.put(index + 3, s3);
        this.cacheValid = false;
    }

    public void put(float[] floatBuf) {
        this.buf.rewind();
        this.buf.put(floatBuf);
        this.buf.rewind();
        this.cacheValid = false;
    }

    public LockableResource getAccelData(FilterContext fctx) {
        Entry entry2;
        if (this.cache == null) {
            this.cache = new HashMap<FilterContext, Entry>();
        } else if (!this.cacheValid) {
            for (Entry entry2 : this.cache.values()) {
                entry2.valid = false;
            }
            this.cacheValid = true;
        }
        Renderer renderer = Renderer.getRenderer(fctx);
        entry2 = this.cache.get(fctx);
        if (entry2 != null) {
            entry2.texture.lock();
            if (entry2.texture.isLost()) {
                entry2.texture.unlock();
                this.cache.remove(fctx);
                entry2 = null;
            }
        }
        if (entry2 == null) {
            LockableResource texture = renderer.createFloatTexture(this.width, this.height);
            entry2 = new Entry(texture);
            this.cache.put(fctx, entry2);
        }
        if (!entry2.valid) {
            renderer.updateFloatTexture(entry2.texture, this);
            entry2.valid = true;
        }
        return entry2.texture;
    }

    private static class Entry {
        LockableResource texture;
        boolean valid;

        Entry(LockableResource texture) {
            this.texture = texture;
        }
    }
}

