/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import com.sun.javafx.collections.ListListenerHelper;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeBuilder;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public abstract class ObservableListBase<E>
extends AbstractList<E>
implements ObservableList<E> {
    private ListListenerHelper<E> listenerHelper;
    private final ListChangeBuilder<E> changeBuilder = new ListChangeBuilder(this);

    protected final void nextUpdate(int pos) {
        this.changeBuilder.nextUpdate(pos);
    }

    protected final void nextSet(int idx, E old) {
        this.changeBuilder.nextSet(idx, old);
    }

    protected final void nextReplace(int from, int to, List<? extends E> removed) {
        this.changeBuilder.nextReplace(from, to, removed);
    }

    protected final void nextRemove(int idx, List<? extends E> removed) {
        this.changeBuilder.nextRemove(idx, removed);
    }

    protected final void nextRemove(int idx, E removed) {
        this.changeBuilder.nextRemove(idx, removed);
    }

    protected final void nextPermutation(int from, int to, int[] perm) {
        this.changeBuilder.nextPermutation(from, to, perm);
    }

    protected final void nextAdd(int from, int to) {
        this.changeBuilder.nextAdd(from, to);
    }

    protected final void beginChange() {
        this.changeBuilder.beginChange();
    }

    protected final void endChange() {
        this.changeBuilder.endChange();
    }

    @Override
    public final void addListener(InvalidationListener listener) {
        this.listenerHelper = ListListenerHelper.addListener(this.listenerHelper, listener);
    }

    @Override
    public final void removeListener(InvalidationListener listener) {
        this.listenerHelper = ListListenerHelper.removeListener(this.listenerHelper, listener);
    }

    @Override
    public final void addListener(ListChangeListener<? super E> listener) {
        this.listenerHelper = ListListenerHelper.addListener(this.listenerHelper, listener);
    }

    @Override
    public final void removeListener(ListChangeListener<? super E> listener) {
        this.listenerHelper = ListListenerHelper.removeListener(this.listenerHelper, listener);
    }

    protected final void fireChange(ListChangeListener.Change<? extends E> change) {
        ListListenerHelper.fireValueChangedEvent(this.listenerHelper, change);
    }

    protected final boolean hasListeners() {
        return ListListenerHelper.hasListeners(this.listenerHelper);
    }

    @Override
    public boolean addAll(E ... elements) {
        return this.addAll(Arrays.asList(elements));
    }

    @Override
    public boolean setAll(E ... elements) {
        return this.setAll((Collection<? extends E>)Arrays.asList(elements));
    }

    @Override
    public boolean setAll(Collection<? extends E> col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(E ... elements) {
        return this.removeAll((Collection<?>)Arrays.asList(elements));
    }

    @Override
    public boolean retainAll(E ... elements) {
        return this.retainAll((Collection<?>)Arrays.asList(elements));
    }

    @Override
    public void remove(int from, int to) {
        this.removeRange(from, to);
    }
}

