/*
 * Decompiled with CFR 0.152.
 */
package divinerpg;

import com.google.common.collect.ImmutableMap;
import divinerpg.capability.ArcanaCapability;
import divinerpg.client.FancyRenders;
import divinerpg.compat.ModCompat;
import divinerpg.config.Config;
import divinerpg.events.ArcanaRenderer;
import divinerpg.recipe.InfusionTableRecipe;
import divinerpg.recipe.InfusionTableRecipeType;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.BuilderRegistry;
import divinerpg.registries.ConfiguredStructureRegistry;
import divinerpg.registries.ContainerRegistry;
import divinerpg.registries.DRPGTab;
import divinerpg.registries.DecoratorRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.EventRegistry;
import divinerpg.registries.FeatureRegistry;
import divinerpg.registries.FluidRegistry;
import divinerpg.registries.KeyRegistry;
import divinerpg.registries.ModelPropRegistry;
import divinerpg.registries.NetworkingRegistry;
import divinerpg.registries.ParticleRegistry;
import divinerpg.registries.RecipeRegistry;
import divinerpg.registries.StructureRegistry;
import divinerpg.registries.TraderProfession;
import divinerpg.registries.TriggerRegistry;
import divinerpg.util.Utils;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.AxeItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="divinerpg")
public class DivineRPG {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "divinerpg";
    public static DRPGTab tabs = new DRPGTab();
    public static final IRecipeType<InfusionTableRecipe> INFUSION_TABLE_RECIPE = new InfusionTableRecipeType();

    public DivineRPG() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::post);
        bus.addListener(this::client);
        bus.addListener(this::gatherData);
        bus.addGenericListener(IRecipeSerializer.class, this::registerRecipeSerializers);
        EventRegistry.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG);
        ParticleRegistry.PARTICLES.register(bus);
        StructureRegistry.DEFERRED_REGISTRY_STRUCTURE.register(bus);
        TraderProfession.PROFESSIONS.register(bus);
        ContainerRegistry.CONTAINER_TYPES.register(bus);
        RecipeRegistry.Serailizers.RECIPE_SERIALIZERS.register(bus);
        KeyRegistry.POI.register(bus);
        FeatureRegistry.FEATURES.register(bus);
        DecoratorRegistry.DECORATORS.register(bus);
        BuilderRegistry.SURFACE_BUILDERS.register(bus);
        FluidRegistry.FLUIDS.register(bus);
    }

    private void setup(FMLCommonSetupEvent event) {
        tabs.init();
        KeyRegistry.init();
        FeatureRegistry.register();
        ModCompat.initCommon(event);
        TriggerRegistry.registerTriggers();
        ArcanaCapability.register();
        NetworkingRegistry.init();
        StructureRegistry.setupStructures();
        ConfiguredStructureRegistry.registerConfiguredStructures();
        event.enqueueWork(() -> {
            AxeItem.field_203176_a = new ImmutableMap.Builder().putAll(AxeItem.field_203176_a).put((Object)BlockRegistry.apalachiaLog, (Object)BlockRegistry.strippedApalachiaLog).put((Object)BlockRegistry.divineLog, (Object)BlockRegistry.strippedDivineLog).put((Object)BlockRegistry.dreamwoodLog, (Object)BlockRegistry.strippedDreamwoodLog).put((Object)BlockRegistry.edenLog, (Object)BlockRegistry.strippedEdenLog).put((Object)BlockRegistry.eucalyptusLog, (Object)BlockRegistry.strippedEucalyptusLog).put((Object)BlockRegistry.firewoodLog, (Object)BlockRegistry.strippedFirewoodLog).put((Object)BlockRegistry.frozenLog, (Object)BlockRegistry.strippedFrozenLog).put((Object)BlockRegistry.hyrewoodLog, (Object)BlockRegistry.strippedHyrewoodLog).put((Object)BlockRegistry.mintwoodLog, (Object)BlockRegistry.strippedMintwoodLog).put((Object)BlockRegistry.mortumLog, (Object)BlockRegistry.strippedMortumLog).put((Object)BlockRegistry.skythernLog, (Object)BlockRegistry.strippedSkythernLog).put((Object)BlockRegistry.wildwoodLog, (Object)BlockRegistry.strippedWildwoodLog).build();
        });
    }

    private void client(FMLClientSetupEvent event) {
        EntityRegistry.render();
        FancyRenders.init();
        MinecraftForge.EVENT_BUS.register((Object)new ArcanaRenderer());
        ModelPropRegistry.init();
        ContainerRegistry.registerScreenFactories();
        Utils.loadHatInformation();
    }

    private void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        Registry.func_218322_a((Registry)Registry.field_218367_H, (ResourceLocation)new ResourceLocation(INFUSION_TABLE_RECIPE.toString()), INFUSION_TABLE_RECIPE);
        event.getRegistry().register((IForgeRegistryEntry)InfusionTableRecipe.SERIALIZER);
    }

    private void post(FMLLoadCompleteEvent event) {
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
    }
}

