/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.arcana;

import divinerpg.blocks.arcana.BlockArcanaPortalFrame;
import divinerpg.blocks.base.BlockMod;
import divinerpg.registries.KeyRegistry;
import divinerpg.util.teleport.ArcanaTeleporter;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;

public class BlockArcanaPortal
extends BlockMod {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public BlockArcanaPortal(String name) {
        super(name, AbstractBlock.Properties.func_200949_a((Material)Material.field_151567_E, (MaterialColor)MaterialColor.field_151649_A).func_200942_a().func_235838_a_(p_235460_0_ -> 15).func_200948_a(-1.0f, 3600000.0f).func_222380_e());
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)this);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (world instanceof ServerWorld && !entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU() && VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ().func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()))), (VoxelShape)state.func_196954_c((IBlockReader)world, pos), (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
            ServerWorld serverworld = ((ServerWorld)world).func_73046_m().func_71218_a(world.func_234923_W_() == KeyRegistry.ARCANA_WORLD ? World.field_234918_g_ : KeyRegistry.ARCANA_WORLD);
            if (serverworld == null) {
                return;
            }
            RegistryKey destination = KeyRegistry.ARCANA_WORLD;
            if (destination == world.func_234923_W_()) {
                destination = World.field_234918_g_;
            }
            if (entity.func_82145_z() > 0) {
                BlockArcanaPortal.transferEntity(entity, world.func_73046_m().func_71218_a(destination));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState p_180655_1_, World p_180655_2_, BlockPos p_180655_3_, Random p_180655_4_) {
        double d0 = (double)p_180655_3_.func_177958_n() + p_180655_4_.nextDouble();
        double d1 = (double)p_180655_3_.func_177956_o() + 0.8;
        double d2 = (double)p_180655_3_.func_177952_p() + p_180655_4_.nextDouble();
        p_180655_2_.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public ItemStack func_185473_a(IBlockReader p_185473_1_, BlockPos p_185473_2_, BlockState p_185473_3_) {
        return ItemStack.field_190927_a;
    }

    public boolean func_225541_a_(BlockState p_225541_1_, Fluid p_225541_2_) {
        return false;
    }

    public static void transferEntity(Entity e, ServerWorld modDimension) {
        if (e == null || modDimension == null) {
            return;
        }
        ArcanaTeleporter teleporter = e.field_70170_p.func_234923_W_() == KeyRegistry.ARCANA_WORLD ? new ArcanaTeleporter(e.func_184102_h().func_71218_a(World.field_234918_g_)) : new ArcanaTeleporter(e.func_184102_h().func_71218_a(KeyRegistry.ARCANA_WORLD));
        e.changeDimension(modDimension, (ITeleporter)teleporter);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos pos2, boolean unknown) {
        BlockPattern.PatternHelper frame = BlockArcanaPortalFrame.getOrCreatePortalShape().func_177681_a((IWorldReader)world, pos);
        if (frame == null && world.func_234923_W_() != KeyRegistry.ARCANA_WORLD) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }
}

