/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import divinerpg.blocks.base.BlockMod;
import divinerpg.registries.BlockRegistry;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolType;

public class BlockModGrass
extends BlockMod
implements IGrowable {
    protected Supplier<Block> dirtSupplier;

    public BlockModGrass(String name, Supplier<Block> dirt, float hardness, MaterialColor colour) {
        super(name, AbstractBlock.Properties.func_200949_a((Material)Material.field_151578_c, (MaterialColor)colour).func_200944_c().func_235861_h_().func_200948_a(hardness, 3.0f).harvestLevel(0).harvestTool(ToolType.SHOVEL).func_200947_a(SoundType.field_185850_c));
        this.dirtSupplier = dirt;
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        return false;
    }

    public boolean func_180670_a(World p_180670_1_, Random p_180670_2_, BlockPos p_180670_3_, BlockState p_180670_4_) {
        return p_180670_1_.func_180495_p(p_180670_3_.func_177984_a()).func_196958_f();
    }

    public boolean func_176473_a(IBlockReader p_176473_1_, BlockPos p_176473_2_, BlockState p_176473_3_, boolean p_176473_4_) {
        return true;
    }

    public BlockState grass() {
        BlockState state = Blocks.field_150349_c.func_176223_P();
        if (this.func_235332_a_(BlockRegistry.edenGrass)) {
            return BlockRegistry.edenBrush.func_176223_P();
        }
        if (this.func_235332_a_(BlockRegistry.wildwoodGrass)) {
            return BlockRegistry.wildwoodTallgrass.func_176223_P();
        }
        if (this.func_235332_a_(BlockRegistry.apalachiaGrass)) {
            return BlockRegistry.apalachiaTallgrass.func_176223_P();
        }
        if (this.func_235332_a_(BlockRegistry.skythernGrass)) {
            return BlockRegistry.skythernBrush.func_176223_P();
        }
        if (this.func_235332_a_(BlockRegistry.mortumGrass)) {
            return BlockRegistry.mortumBrush.func_176223_P();
        }
        return state;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.func_177984_a();
        BlockState blockstate = this.grass();
        block0: for (int i = 0; i < 128; ++i) {
            BlockState blockstate1;
            BlockPos blockpos1 = blockpos;
            for (int j = 0; j < i / 16; ++j) {
                if (!worldIn.func_180495_p((blockpos1 = blockpos1.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b()).func_203425_a((Block)this) || worldIn.func_180495_p(blockpos1).isFertile((IBlockReader)worldIn, blockpos1)) continue block0;
            }
            BlockState blockstate2 = worldIn.func_180495_p(blockpos1);
            if (blockstate2.func_203425_a(blockstate.func_177230_c()) && rand.nextInt(10) == 0) {
                this.func_225535_a_(worldIn, rand, blockpos1, blockstate2);
            }
            if (!blockstate2.func_196958_f()) continue;
            if (rand.nextInt(8) == 0) {
                List list = worldIn.func_226691_t_(blockpos1).func_242440_e().func_242496_b();
                if (list.isEmpty()) continue;
                ConfiguredFeature configuredfeature = (ConfiguredFeature)list.get(0);
                FlowersFeature flowersfeature = (FlowersFeature)configuredfeature.field_222737_a;
                blockstate1 = flowersfeature.func_225562_b_(rand, blockpos1, configuredfeature.func_242767_c());
            } else {
                blockstate1 = blockstate;
            }
            if (!blockstate1.func_196955_c((IWorldReader)worldIn, blockpos1) || worldIn.func_180495_p(blockpos1.func_177977_b()) == blockstate1) continue;
            worldIn.func_180501_a(blockpos1, blockstate1, 3);
            if (!(blockstate1.func_177230_c() instanceof DoublePlantBlock)) continue;
            worldIn.func_180501_a(blockpos1.func_177984_a(), (BlockState)blockstate1.func_206870_a((Property)BlockStateProperties.field_208163_P, (Comparable)DoubleBlockHalf.UPPER), 3);
        }
    }

    private static boolean canBeGrass(BlockState p_220257_0_, IWorldReader p_220257_1_, BlockPos p_220257_2_) {
        BlockPos blockpos = p_220257_2_.func_177984_a();
        BlockState blockstate = p_220257_1_.func_180495_p(blockpos);
        if (blockstate.func_203425_a(Blocks.field_150433_aE) && (Integer)blockstate.func_177229_b((Property)SnowBlock.field_176315_a) == 1) {
            return true;
        }
        if (blockstate.func_204520_s().func_206882_g() == 8) {
            return false;
        }
        int i = LightEngine.func_215613_a((IBlockReader)p_220257_1_, (BlockState)p_220257_0_, (BlockPos)p_220257_2_, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.func_200016_a((IBlockReader)p_220257_1_, blockpos));
        return i < p_220257_1_.func_201572_C();
    }

    private static boolean canPropagate(BlockState p_220256_0_, IWorldReader p_220256_1_, BlockPos p_220256_2_) {
        BlockPos blockpos = p_220256_2_.func_177984_a();
        return BlockModGrass.canBeGrass(p_220256_0_, p_220256_1_, p_220256_2_) && !p_220256_1_.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public void func_225542_b_(BlockState p_225542_1_, ServerWorld p_225542_2_, BlockPos p_225542_3_, Random p_225542_4_) {
        if (!BlockModGrass.canBeGrass(p_225542_1_, (IWorldReader)p_225542_2_, p_225542_3_)) {
            if (!p_225542_2_.isAreaLoaded(p_225542_3_, 3)) {
                return;
            }
            p_225542_2_.func_175656_a(p_225542_3_, this.dirtSupplier.get().func_176223_P());
        } else if (p_225542_2_.func_201696_r(p_225542_3_.func_177984_a()) >= 9) {
            BlockState blockstate = this.func_176223_P();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = p_225542_3_.func_177982_a(p_225542_4_.nextInt(3) - 1, p_225542_4_.nextInt(5) - 3, p_225542_4_.nextInt(3) - 1);
                if (!p_225542_2_.func_180495_p(blockpos).func_203425_a(this.dirtSupplier.get()) || !BlockModGrass.canPropagate(blockstate, (IWorldReader)p_225542_2_, blockpos)) continue;
                p_225542_2_.func_175656_a(blockpos, blockstate.getBlockState());
            }
        }
    }
}

