/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import divinerpg.blocks.base.BlockMod;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.KeyRegistry;
import divinerpg.registries.ParticleRegistry;
import divinerpg.util.teleport.DivineTeleporter;
import divinerpg.util.teleport.VetheaTeleporter;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockModPortal
extends BlockMod {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.field_208199_z;
    protected static final VoxelShape X_AXIS_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static Block frame;

    public BlockModPortal(String name, Block frame) {
        super(name, AbstractBlock.Properties.func_200945_a((Material)Material.field_151567_E).func_200943_b(-1.0f).func_200942_a().func_235838_a_(state -> 11).func_222380_e());
        BlockModPortal.frame = frame;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
    }

    private Block getFrame() {
        return frame;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction.Axis)state.func_177229_b(AXIS)) {
            case Z: {
                return Z_AXIS_AABB;
            }
        }
        return X_AXIS_AABB;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.func_176740_k();
        Direction.Axis direction$axis1 = (Direction.Axis)stateIn.func_177229_b(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.func_176722_c();
        return !flag && facingState.func_177230_c() != this && !new Size(worldIn, currentPos, direction$axis1, this.getBlock(), frame).validatePortal() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU() && !entity.field_70170_p.field_72995_K) {
            if (entity.func_242280_ah()) {
                entity.func_242279_ag();
            }
            if (!entity.func_242280_ah() && entity instanceof LivingEntity) {
                entity.field_70170_p.func_217381_Z().func_76320_a(world.func_234923_W_().getRegistryName().func_110623_a());
                if (this == BlockRegistry.edenPortal) {
                    RegistryKey<World> key = world.func_234923_W_() == KeyRegistry.EDEN_WORLD ? World.field_234918_g_ : KeyRegistry.EDEN_WORLD;
                    entity.changeDimension(world.func_73046_m().func_71218_a(key), (ITeleporter)new DivineTeleporter(world.func_73046_m().func_71218_a(key), BlockRegistry.edenPortal, BlockRegistry.divineRock, true, (PointOfInterestType)KeyRegistry.EDEN_PORTAL.get()));
                } else if (this == BlockRegistry.wildwoodPortal) {
                    RegistryKey<World> key = world.func_234923_W_() == KeyRegistry.WILDWOOD_WORLD ? World.field_234918_g_ : KeyRegistry.WILDWOOD_WORLD;
                    entity.changeDimension(world.func_73046_m().func_71218_a(key), (ITeleporter)new DivineTeleporter(world.func_73046_m().func_71218_a(key), BlockRegistry.wildwoodPortal, BlockRegistry.edenBlock, true, (PointOfInterestType)KeyRegistry.WILDWOOD_PORTAL.get()));
                } else if (this == BlockRegistry.apalachiaPortal) {
                    RegistryKey<World> key = world.func_234923_W_() == KeyRegistry.APALACHIA_WORLD ? World.field_234918_g_ : KeyRegistry.APALACHIA_WORLD;
                    entity.changeDimension(world.func_73046_m().func_71218_a(key), (ITeleporter)new DivineTeleporter(world.func_73046_m().func_71218_a(key), BlockRegistry.apalachiaPortal, BlockRegistry.wildwoodBlock, true, (PointOfInterestType)KeyRegistry.APALACHIA_PORTAL.get()));
                } else if (this == BlockRegistry.skythernPortal) {
                    RegistryKey<World> key = world.func_234923_W_() == KeyRegistry.SKYTHERN_WORLD ? World.field_234918_g_ : KeyRegistry.SKYTHERN_WORLD;
                    entity.changeDimension(world.func_73046_m().func_71218_a(key), (ITeleporter)new DivineTeleporter(world.func_73046_m().func_71218_a(key), BlockRegistry.skythernPortal, BlockRegistry.apalachiaBlock, true, (PointOfInterestType)KeyRegistry.SKYTHERN_PORTAL.get()));
                } else if (this == BlockRegistry.mortumPortal) {
                    RegistryKey<World> key = world.func_234923_W_() == KeyRegistry.MORTUM_WORLD ? World.field_234918_g_ : KeyRegistry.MORTUM_WORLD;
                    entity.changeDimension(world.func_73046_m().func_71218_a(key), (ITeleporter)new DivineTeleporter(world.func_73046_m().func_71218_a(key), BlockRegistry.mortumPortal, BlockRegistry.skythernBlock, true, (PointOfInterestType)KeyRegistry.MORTUM_PORTAL.get()));
                } else if (this == BlockRegistry.iceikaPortal) {
                    RegistryKey<World> key = world.func_234923_W_() == KeyRegistry.ICEIKA_WORLD ? World.field_234918_g_ : KeyRegistry.ICEIKA_WORLD;
                    entity.changeDimension(world.func_73046_m().func_71218_a(key), (ITeleporter)new DivineTeleporter(world.func_73046_m().func_71218_a(key), BlockRegistry.iceikaPortal, Blocks.field_196604_cC, true, (PointOfInterestType)KeyRegistry.ICEIKA_PORTAL.get()));
                } else if (this == BlockRegistry.vetheaPortal) {
                    RegistryKey<World> key = world.func_234923_W_() == KeyRegistry.VETHEA_WORLD ? World.field_234918_g_ : KeyRegistry.VETHEA_WORLD;
                    entity.changeDimension(world.func_73046_m().func_71218_a(key), (ITeleporter)new VetheaTeleporter(world.func_73046_m().func_71218_a(key)));
                }
                entity.field_70170_p.func_217381_Z().func_76319_b();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.func_177958_n() + rand.nextDouble();
            double y = (double)pos.func_177956_o() + rand.nextDouble();
            double z = (double)pos.func_177952_p() + rand.nextDouble();
            double xSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double ySpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double zSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (!worldIn.func_180495_p(pos.func_177976_e()).func_203425_a((Block)this) && !worldIn.func_180495_p(pos.func_177974_f()).func_203425_a((Block)this)) {
                x = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                xSpeed = rand.nextFloat() * 2.0f * (float)j;
            } else {
                z = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                zSpeed = rand.nextFloat() * 2.0f * (float)j;
            }
            if (this == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "eden_portal"))) {
                worldIn.func_195594_a((IParticleData)ParticleRegistry.EDEN_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
                continue;
            }
            if (this == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "wildwood_portal"))) {
                worldIn.func_195594_a((IParticleData)ParticleRegistry.WILDWOOD_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
                continue;
            }
            if (this == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "apalachia_portal"))) {
                worldIn.func_195594_a((IParticleData)ParticleRegistry.APALACHIA_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
                continue;
            }
            if (this == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "skythern_portal"))) {
                worldIn.func_195594_a((IParticleData)ParticleRegistry.SKYTHERN_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
                continue;
            }
            if (this == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "mortum_portal"))) {
                worldIn.func_195594_a((IParticleData)ParticleRegistry.MORTUM_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
                continue;
            }
            if (this == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "iceika_portal"))) {
                worldIn.func_195594_a((IParticleData)ParticleRegistry.FROST.get(), x, y, z, xSpeed, ySpeed, zSpeed);
                continue;
            }
            if (this == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("divinerpg", "vethea_portal"))) {
                worldIn.func_195594_a((IParticleData)ParticleRegistry.MORTUM_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
                continue;
            }
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AXIS});
    }

    public boolean makePortal(IWorld worldIn, BlockPos pos) {
        Size portal = this.isPortal(worldIn, pos);
        if (portal != null && !BlockModPortal.onTrySpawnPortal(worldIn, pos, portal)) {
            portal.createPortalBlocks();
            return true;
        }
        return false;
    }

    public static boolean onTrySpawnPortal(IWorld world, BlockPos pos, Size size) {
        return MinecraftForge.EVENT_BUS.post((Event)new PortalSpawnEvent(world, pos, world.func_180495_p(pos), size));
    }

    @Nullable
    public Size isPortal(IWorld worldIn, BlockPos pos) {
        Size portalX = new Size(worldIn, pos, Direction.Axis.X, this, worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
        if (portalX.isValid() && portalX.portalBlockCount == 0) {
            return portalX;
        }
        Size portalZ = new Size(worldIn, pos, Direction.Axis.Z, this, worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
        return portalZ.isValid() && portalZ.portalBlockCount == 0 ? portalZ : null;
    }

    public static class Size {
        private final IWorld world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private Block portal;
        private Block frame;

        public Size(IWorld worldIn, BlockPos pos, Direction.Axis axisIn, Block portal, Block frame) {
            this.world = worldIn;
            this.axis = axisIn;
            this.portal = portal;
            this.frame = frame;
            if (axisIn == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.canConnect(worldIn.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos pos, Direction directionIn) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.canConnect(this.world.func_180495_p(blockpos = pos.func_177967_a(directionIn, i))) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c().func_235332_a_(this.world.func_180495_p(pos.func_177977_b()).func_177230_c()); ++i) {
            }
            BlockPos framePos = pos.func_177967_a(directionIn, i);
            return this.world.func_180495_p(framePos).func_177230_c().func_235332_a_(this.world.func_180495_p(pos.func_177977_b()).func_177230_c()) ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos framePos;
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    BlockState blockstate = this.world.func_180495_p(blockpos);
                    if (!this.canConnect(blockstate)) break block0;
                    Block block = blockstate.func_177230_c();
                    if (block == this.portal) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? !this.world.func_180495_p(framePos = blockpos.func_177972_a(this.leftDir)).func_177230_c().func_235332_a_(this.frame) || this.world.func_180495_p(framePos).func_177230_c() != this.frame : i == this.width - 1 && (!this.world.func_180495_p(framePos = blockpos.func_177972_a(this.rightDir)).func_177230_c().func_235332_a_(this.frame) || this.world.func_180495_p(framePos).func_177230_c() != this.frame)) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                BlockPos framePos = this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height);
                if (!this.world.func_180495_p(framePos).func_177230_c().func_235332_a_(this.frame)) {
                    this.height = 0;
                    break;
                }
                if (this.world.func_180495_p(framePos).func_177230_c() == this.frame) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean canConnect(BlockState pos) {
            Block block = pos.func_177230_c();
            return pos.func_196958_f() || block == this.portal;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void createPortalBlocks() {
            BlockState blockstate = (BlockState)this.portal.func_176223_P().func_206870_a(AXIS, (Comparable)this.axis);
            BlockPos.func_218278_a((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.func_177967_a(Direction.UP, this.height - 1).func_177967_a(this.rightDir, this.width - 1)).forEach(pos -> this.world.func_180501_a(pos, blockstate, 18));
        }

        private boolean isPortalCountValidForSize() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean validatePortal() {
            return this.isValid() && this.isPortalCountValidForSize();
        }
    }

    @Cancelable
    public static class PortalSpawnEvent
    extends BlockEvent {
        private final Size size;

        public PortalSpawnEvent(IWorld world, BlockPos pos, BlockState state, Size size) {
            super(world, pos, state);
            this.size = size;
        }

        public Size getPortalSize() {
            return this.size;
        }
    }
}

