/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import divinerpg.blocks.base.BlockMod;
import divinerpg.registries.ParticleRegistry;
import divinerpg.tiles.spawner.TileEntitySingleUseSpawner;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockSingleUseSpawner
extends BlockMod
implements ITileEntityProvider {
    private final EntityType entityClass;
    private final int delay;
    private String name;
    private int nearDistance;
    private BlockPos spawnOffset;
    protected Supplier<Item> activationItemSupplier;

    public BlockSingleUseSpawner(String name, EntityType entityClass, Supplier<Item> activationItemSupplier, int delay, int nearDistance) {
        this(name, entityClass, activationItemSupplier, delay, nearDistance, BlockPos.field_177992_a);
    }

    public BlockSingleUseSpawner(String name, EntityType entityClass, Supplier<Item> activationItemSupplier, int delay, int nearDistance, BlockPos spawnOffset) {
        super(name, AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151665_m).func_235861_h_().func_200948_a(1.0f, 3.0f).func_200947_a(SoundType.field_185851_d).func_226896_b_());
        this.entityClass = entityClass;
        this.activationItemSupplier = activationItemSupplier;
        this.delay = delay;
        this.name = name;
        this.nearDistance = nearDistance;
        this.spawnOffset = spawnOffset;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        ItemStack heldItem = player.func_184614_ca();
        Item activationItem = this.activationItemSupplier.get();
        if (world.func_175659_aa() == Difficulty.PEACEFUL) {
            if (world.field_72995_K && hand == Hand.MAIN_HAND) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.spawner.peaceful"), player.func_110124_au());
            }
            return ActionResultType.FAIL;
        }
        if (heldItem.func_77973_b() != activationItem && activationItem != null) {
            if (world.field_72995_K && hand == Hand.MAIN_HAND) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.spawner.item", new Object[]{String.format("%s", activationItem.func_200296_o().getString())}), player.func_110124_au());
            }
            return ActionResultType.FAIL;
        }
        TileEntity spawnerTile = world.func_175625_s(pos);
        if (spawnerTile instanceof TileEntitySingleUseSpawner && !((TileEntitySingleUseSpawner)spawnerTile).isActivated() && !world.field_72995_K && hand == Hand.MAIN_HAND) {
            ((TileEntitySingleUseSpawner)spawnerTile).activate(player);
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
        }
        return ActionResultType.PASS;
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntitySingleUseSpawner) || !((TileEntitySingleUseSpawner)tileEntity).isActivated()) {
            return;
        }
        worldIn.func_195594_a((IParticleData)ParticleRegistry.BLACK_FLAME.get(), (double)pos.func_177956_o() + Math.random() - Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random() - Math.random(), Math.random(), Math.random(), Math.random());
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader reader) {
        return new TileEntitySingleUseSpawner(this.entityClass, this.delay, this.nearDistance, this.spawnOffset);
    }

    public VoxelShape func_230322_a_(BlockState p_230322_1_, IBlockReader p_230322_2_, BlockPos p_230322_3_, ISelectionContext p_230322_4_) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_200123_i(BlockState p_200123_1_, IBlockReader p_200123_2_, BlockPos p_200123_3_) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }
}

