/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import divinerpg.blocks.base.BlockMod;
import divinerpg.enums.StatueType;
import divinerpg.tiles.bosses.TileEntityStatue;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class BlockStatue
extends BlockMod
implements ITileEntityProvider {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public StatueType statueType;
    private SoundEvent statueSound;
    public static final VoxelShape WATCHER_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, 0.5, (double)0.7f));
    public static final VoxelShape AYERACO_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.4f, (double)0.8f));
    public static final VoxelShape TWILIGHT_DEMON_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 1.0, (double)0.8f));
    public static final VoxelShape VAMACHERON_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, (double)0.7f, (double)0.8f));
    public static final VoxelShape PARASECTA_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.2f, (double)0.2f, (double)0.2f, (double)0.8f, 1.0, (double)0.8f));
    public static final VoxelShape SOUL_FIEND_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 1.0, (double)0.8f));

    public BlockStatue(String name, StatueType statueType, SoundEvent soundIn) {
        super(name, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(6.0f, 6.0f).harvestLevel(0).harvestTool(ToolType.PICKAXE).func_226896_b_());
        this.statueType = statueType;
        this.hasTileEntity(this.func_176223_P());
        this.statueSound = soundIn;
    }

    public boolean func_200122_a(BlockState p_200122_1_, BlockState p_200122_2_, Direction p_200122_3_) {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader reader) {
        return new TileEntityStatue(this.statueType);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity player, ItemStack stack) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)FACING, (Comparable)player.func_174811_aO().func_176734_d()), 2);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, BlockState state) {
        if (!worldIn.field_72995_K) {
            BlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            BlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            BlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            BlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            Direction enumfacing = (Direction)state.func_177229_b((Property)FACING);
            if (enumfacing == Direction.NORTH) {
                enumfacing = Direction.SOUTH;
            } else if (enumfacing == Direction.SOUTH) {
                enumfacing = Direction.NORTH;
            } else if (enumfacing == Direction.WEST) {
                enumfacing = Direction.EAST;
            } else if (enumfacing == Direction.EAST) {
                enumfacing = Direction.WEST;
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)FACING, (Comparable)enumfacing), 2);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        int hitX = trace.func_216350_a().func_177958_n();
        int hitY = trace.func_216350_a().func_177956_o();
        int hitZ = trace.func_216350_a().func_177952_p();
        if (!player.func_213453_ef() && this.statueSound != null) {
            world.func_184133_a(null, pos, this.statueSound, SoundCategory.BLOCKS, 20.0f, 1.0f);
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext context) {
        if (this.statueType != null) {
            switch (this.statueType) {
                case RED_AYERACO_STATUE: 
                case BLUE_AYERACO_STATUE: 
                case GREEN_AYERACO_STATUE: 
                case PURPLE_AYERACO_STATUE: 
                case YELLOW_AYERACO_STATUE: {
                    return AYERACO_AABB;
                }
                case THE_WATCHER_STATUE: {
                    return WATCHER_AABB;
                }
                case TWILIGHT_DEMON_STATUE: {
                    return TWILIGHT_DEMON_AABB;
                }
                case VAMACHERON_STATUE: {
                    return VAMACHERON_AABB;
                }
                case PARASECTA_STATUE: {
                    return PARASECTA_AABB;
                }
                case SOUL_FIEND_STATUE: {
                    return SOUL_FIEND_AABB;
                }
            }
        }
        return VoxelShapes.func_197868_b();
    }
}

