/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.twilight;

import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class BlockTwilightFlower
extends BushBlock
implements IPlantable {
    private Supplier<Block> grassSupplier;
    private AxisAlignedBB size;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);

    public BlockTwilightFlower(String name, Supplier<Block> grassSupplier, MaterialColor color) {
        this(name, grassSupplier, 0.4, 1.0, color);
    }

    public BlockTwilightFlower(String name, Supplier<Block> grassSupplier, double width, double height, MaterialColor color) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151585_k, (MaterialColor)color).func_200946_b().func_226896_b_().func_200947_a(SoundType.field_222472_s).func_200942_a().func_200944_c());
        this.setRegistryName("divinerpg", name);
        this.grassSupplier = grassSupplier;
        if (width <= 0.0 || height <= 0.0) {
            throw new RuntimeException("Width or height cannot be less/equals zero!");
        }
        double leftCorner = Double.max(0.0, 0.5 - width / 2.0);
        double rightCorner = 0.5 + width / 2.0;
        this.size = new AxisAlignedBB(leftCorner, 0.0, leftCorner, rightCorner, height, rightCorner);
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader reader, BlockPos pos) {
        BlockState soil = reader.func_180495_p(pos.func_177977_b());
        return soil.func_177230_c() == this.grassSupplier.get();
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        return state.func_177230_c() == this.grassSupplier.get();
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        Vector3d vector3d = p_220053_1_.func_191059_e(p_220053_2_, p_220053_3_);
        return SHAPE.func_197751_a(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    public Block getGrass() {
        return this.grassSupplier.get();
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.PLAINS;
    }
}

