/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vanilla;

import divinerpg.client.containers.AltarOfCorruptionContainer;
import divinerpg.registries.TileRegistry;
import divinerpg.registries.TriggerRegistry;
import divinerpg.tiles.AltarOfCorruptionEntity;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockAltarOfCorruption
extends ContainerBlock {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public BlockAltarOfCorruption(String name) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151649_A).func_235861_h_().func_200948_a(5.0f, 2000.0f).func_200947_a(SoundType.field_185851_d));
        this.setRegistryName(name);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, worldIn, pos, rand);
        for (int i = -2; i <= 2; ++i) {
            block1: for (int j = -2; j <= 2; ++j) {
                if (i > -2 && i < 2 && j == -1) {
                    j = 2;
                }
                if (rand.nextInt(16) != 0) continue;
                for (int k = 0; k <= 1; ++k) {
                    BlockPos blockpos = pos.func_177982_a(i, k, j);
                    if (!(worldIn.func_180495_p(blockpos).getEnchantPowerBonus((IWorldReader)worldIn, blockpos) > 0.0f)) continue;
                    if (!worldIn.func_175623_d(pos.func_177982_a(i / 2, 0, j / 2))) continue block1;
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.0, (double)pos.func_177952_p() + 0.5, (double)((float)i + rand.nextFloat()) - 0.5, (double)((float)k - rand.nextFloat() - 1.0f), (double)((float)j + rand.nextFloat()) - 0.5);
                }
            }
        }
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public boolean func_220074_n(BlockState p_220074_1_) {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new AltarOfCorruptionEntity(TileRegistry.ALTAR_OF_CORRUPTION);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        player.func_213829_a(state.func_215699_b(worldIn, pos));
        TriggerRegistry.DIVINERPG_BLOCK.trigger((ServerPlayerEntity)player, (Block)this);
        return ActionResultType.CONSUME;
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof AltarOfCorruptionEntity) {
            ITextComponent itextcomponent = ((INameable)tileentity).func_145748_c_();
            return new SimpleNamedContainerProvider((id, inventory, player) -> new AltarOfCorruptionContainer(id, inventory, IWorldPosCallable.func_221488_a((World)worldIn, (BlockPos)pos)), itextcomponent);
        }
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof AltarOfCorruptionEntity) {
            ((AltarOfCorruptionEntity)tileentity).setCustomName(stack.func_151000_E());
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

