/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vethea;

import divinerpg.entities.projectile.EntityDivineArrow;
import divinerpg.enums.ArrowType;
import divinerpg.registries.EntityRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.Position;
import net.minecraft.dispenser.ProxyBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.DropperTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockKarosDispenser
extends ContainerBlock {
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.field_208197_x;
    private static final Map<Item, IDispenseItemBehavior> DISPENSER_REGISTRY = (Map)Util.func_200696_a((Object)new Object2ObjectOpenHashMap(), p_212564_0_ -> p_212564_0_.defaultReturnValue((Object)new DefaultDispenseItemBehavior()));

    public static void registerBehavior(IItemProvider provider, IDispenseItemBehavior behavior) {
        DISPENSER_REGISTRY.put(provider.func_199767_j(), behavior);
    }

    public BlockKarosDispenser(String name) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(-1.0f, 6000000.0f));
        this.setRegistryName(name);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (p_225533_2_.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileentity = p_225533_2_.func_175625_s(p_225533_3_);
        if (tileentity instanceof DispenserTileEntity) {
            p_225533_4_.func_213829_a((INamedContainerProvider)((DispenserTileEntity)tileentity));
            if (tileentity instanceof DropperTileEntity) {
                p_225533_4_.func_195066_a(Stats.field_188083_Q);
            } else {
                p_225533_4_.func_195066_a(Stats.field_188085_S);
            }
        }
        return ActionResultType.CONSUME;
    }

    public void dispenseFrom(ServerWorld world, BlockPos pos) {
        double var5 = pos.func_177958_n();
        double var7 = pos.func_177956_o();
        double var9 = pos.func_177952_p();
        ProxyBlockSource proxyblocksource = new ProxyBlockSource(world, pos);
        Direction direction = (Direction)proxyblocksource.func_189992_e().func_177229_b((Property)FACING);
        EntityDivineArrow var11 = new EntityDivineArrow(EntityRegistry.ARROW_SHOT, (World)world, ArrowType.KAROS_ARROW, var5 + 0.5 + (double)direction.func_82601_c(), var7 + 0.5, var9 + 0.5 + (double)direction.func_82599_e());
        var11.damageMax = 12.0;
        var11.damageMin = 12.0;
        double var12 = world.field_73012_v.nextDouble() * 0.1 + 0.9;
        var11.func_213293_j((double)direction.func_82601_c() * var12, 0.0, (double)direction.func_82599_e() * var12);
        var11.func_213293_j(var11.func_213322_ci().field_72450_a, var11.func_213322_ci().field_72448_b + 0.0, var11.func_213322_ci().field_72449_c);
        world.func_217376_c((Entity)var11);
    }

    protected IDispenseItemBehavior getDispenseMethod(ItemStack stack) {
        return DISPENSER_REGISTRY.get(stack.func_77973_b());
    }

    public void func_220069_a(BlockState p_220069_1_, World p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        boolean flag = p_220069_2_.func_175640_z(p_220069_3_) || p_220069_2_.func_175640_z(p_220069_3_.func_177984_a());
        boolean flag1 = (Boolean)p_220069_1_.func_177229_b((Property)TRIGGERED);
        if (flag && !flag1) {
            p_220069_2_.func_205220_G_().func_205360_a(p_220069_3_, (Object)this, 4);
            p_220069_2_.func_180501_a(p_220069_3_, (BlockState)p_220069_1_.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!flag && flag1) {
            p_220069_2_.func_180501_a(p_220069_3_, (BlockState)p_220069_1_.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        this.dispenseFrom(p_225534_2_, p_225534_3_);
    }

    public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
        return new DispenserTileEntity();
    }

    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)p_196258_1_.func_196010_d().func_176734_d());
    }

    public void func_180633_a(World p_180633_1_, BlockPos p_180633_2_, BlockState p_180633_3_, LivingEntity p_180633_4_, ItemStack p_180633_5_) {
        TileEntity tileentity;
        if (p_180633_5_.func_82837_s() && (tileentity = p_180633_1_.func_175625_s(p_180633_2_)) instanceof DispenserTileEntity) {
            ((DispenserTileEntity)tileentity).func_213903_a(p_180633_5_.func_200301_q());
        }
    }

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.func_203425_a(p_196243_4_.func_177230_c())) {
            TileEntity tileentity = p_196243_2_.func_175625_s(p_196243_3_);
            if (tileentity instanceof DispenserTileEntity) {
                InventoryHelper.func_180175_a((World)p_196243_2_, (BlockPos)p_196243_3_, (IInventory)((DispenserTileEntity)tileentity));
                p_196243_2_.func_175666_e(p_196243_3_, (Block)this);
            }
            super.func_196243_a(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public static IPosition getDispensePosition(IBlockSource p_149939_0_) {
        Direction direction = (Direction)p_149939_0_.func_189992_e().func_177229_b((Property)FACING);
        double d0 = p_149939_0_.func_82615_a() + 0.7 * (double)direction.func_82601_c();
        double d1 = p_149939_0_.func_82617_b() + 0.7 * (double)direction.func_96559_d();
        double d2 = p_149939_0_.func_82616_c() + 0.7 * (double)direction.func_82599_e();
        return new Position(d0, d1, d2);
    }

    public boolean func_149740_M(BlockState p_149740_1_) {
        return true;
    }

    public int func_180641_l(BlockState p_180641_1_, World p_180641_2_, BlockPos p_180641_3_) {
        return Container.func_178144_a((TileEntity)p_180641_2_.func_175625_s(p_180641_3_));
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.func_206870_a((Property)FACING, (Comparable)p_185499_2_.func_185831_a((Direction)p_185499_1_.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.func_185907_a(p_185471_2_.func_185800_a((Direction)p_185471_1_.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{FACING, TRIGGERED});
    }
}

