/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.capability;

import divinerpg.capability.PacketArcanaBar;
import divinerpg.config.Config;
import divinerpg.registries.NetworkingRegistry;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;

public class Arcana {
    private int tickDelay = 4;
    private float max = 200.0f;
    private float arcana = ((Integer)Config.maxArcana.get()).intValue();

    public Arcana() {
        this(200.0f);
    }

    public Arcana(float initialChargeLevel) {
        this.arcana = initialChargeLevel;
    }

    public float getArcana() {
        return this.arcana;
    }

    public void consume(PlayerEntity player, float points) {
        if (player.func_184812_l_()) {
            return;
        }
        this.set(this.getArcana() - points);
        this.sendPacket(player);
    }

    public void fill(PlayerEntity player, float points) {
        float prev = this.getArcana();
        this.set(prev + points);
        if (prev != this.getArcana()) {
            this.sendPacket(player);
        }
    }

    public void regen(PlayerEntity player) {
        if (player.field_70170_p.func_82737_E() % (long)this.tickDelay == 0L) {
            this.fill(player, 1.0f);
        }
    }

    public void set(float points) {
        this.arcana = MathHelper.func_76131_a((float)points, (float)0.0f, (float)this.getMaxArcana());
    }

    public float getMaxArcana() {
        return this.max;
    }

    public void setMaxArcana(float max) {
        if (max < 0.0f) {
            throw new IllegalArgumentException("Max of arcana can't be less then null!");
        }
        this.max = max;
    }

    public int getRegenDelay() {
        return this.tickDelay;
    }

    public void setRegenDelay(int delay) {
        if (delay < 1) {
            throw new IllegalArgumentException("Tick delay beetween regen can't be less than one!");
        }
        this.tickDelay = delay;
    }

    private void sendPacket(PlayerEntity player) {
        if (!(player instanceof FakePlayer) && player instanceof ServerPlayerEntity && player != null) {
            NetworkingRegistry.INSTANCE.sendTo((Object)new PacketArcanaBar(this), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static Arcana createADefaultInstance() {
        return new Arcana();
    }

    public static class ArcanaStorage
    implements Capability.IStorage<Arcana> {
        public INBT writeNBT(Capability<Arcana> capability, Arcana instance, Direction side) {
            FloatNBT floatNBT = FloatNBT.func_229689_a_((float)instance.arcana);
            return floatNBT;
        }

        public void readNBT(Capability<Arcana> capability, Arcana instance, Direction side, INBT nbt) {
            float arcana = 0.0f;
            if (nbt.func_225647_b_() == FloatNBT.field_229688_b_) {
                arcana = ((FloatNBT)nbt).func_150288_h();
            }
            instance.set(arcana);
        }
    }
}

