/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.capability;

import divinerpg.capability.Arcana;
import divinerpg.capability.ArcanaCapability;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketArcanaBar {
    private int delay;
    private float arcana;
    private float max;

    public PacketArcanaBar(ByteBuf buf) {
        this.max = buf.readFloat();
        this.arcana = buf.readFloat();
        this.delay = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.max);
        buf.writeFloat(this.arcana);
        buf.writeInt(this.delay);
    }

    public PacketArcanaBar(Arcana arcana) {
        if (arcana == null) {
            return;
        }
        this.delay = arcana.getRegenDelay();
        this.arcana = arcana.getArcana();
        this.max = arcana.getMaxArcana();
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Arcana arcana = (Arcana)((NetworkEvent.Context)ctx.get()).getSender().getCapability(ArcanaCapability.CAPABILITY_ARCANA).orElseThrow(null);
            arcana.setMaxArcana(this.max);
            arcana.setRegenDelay(this.delay);
            arcana.set(this.arcana);
        });
        ctx.get().setPacketHandled(true);
    }
}

