/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.client.models.twilight;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.IHasHead;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelHelper;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelEnchantedWarrior<T extends LivingEntity>
extends AgeableModel<T>
implements IHasArm,
IHasHead {
    public ModelRenderer head;
    public ModelRenderer hat;
    public ModelRenderer body;
    public ModelRenderer rightArm;
    public ModelRenderer leftArm;
    public ModelRenderer rightLeg;
    public ModelRenderer leftLeg;
    public BipedModel.ArmPose leftArmPose = BipedModel.ArmPose.EMPTY;
    public BipedModel.ArmPose rightArmPose = BipedModel.ArmPose.EMPTY;
    public boolean crouching;
    public float swimAmount;
    ModelRenderer hornright;
    ModelRenderer hornleft;

    public ModelEnchantedWarrior() {
        this(RenderType::func_228640_c_, 1.0f, 0.0f, 64, 32);
    }

    protected ModelEnchantedWarrior(float p_i1149_1_, float p_i1149_2_, int p_i1149_3_, int p_i1149_4_) {
        this(RenderType::func_228640_c_, p_i1149_1_, p_i1149_2_, p_i1149_3_, p_i1149_4_);
    }

    public ModelEnchantedWarrior(Function<ResourceLocation, RenderType> p_i225946_1_, float p_i225946_2_, float p_i225946_3_, int p_i225946_4_, int p_i225946_5_) {
        super(p_i225946_1_, true, 16.0f, 0.0f, 2.0f, 2.0f, 24.0f);
        this.field_78090_t = p_i225946_4_;
        this.field_78089_u = p_i225946_5_;
        this.head = new ModelRenderer((Model)this, 0, 0);
        this.head.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_i225946_2_);
        this.head.func_78793_a(0.0f, 0.0f + p_i225946_3_, 0.0f);
        this.hat = new ModelRenderer((Model)this, 32, 0);
        this.hat.func_228301_a_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_i225946_2_ + 0.5f);
        this.hat.func_78793_a(0.0f, 0.0f + p_i225946_3_, 0.0f);
        this.body = new ModelRenderer((Model)this, 16, 16);
        this.body.func_228301_a_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_i225946_2_);
        this.body.func_78793_a(0.0f, 0.0f + p_i225946_3_, 0.0f);
        this.rightArm = new ModelRenderer((Model)this, 40, 16);
        this.rightArm.func_228301_a_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_i225946_2_);
        this.rightArm.func_78793_a(-5.0f, 2.0f + p_i225946_3_, 0.0f);
        this.leftArm = new ModelRenderer((Model)this, 40, 16);
        this.leftArm.field_78809_i = true;
        this.leftArm.func_228301_a_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_i225946_2_);
        this.leftArm.func_78793_a(5.0f, 2.0f + p_i225946_3_, 0.0f);
        this.rightLeg = new ModelRenderer((Model)this, 0, 16);
        this.rightLeg.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_i225946_2_);
        this.rightLeg.func_78793_a(-1.9f, 12.0f + p_i225946_3_, 0.0f);
        this.leftLeg = new ModelRenderer((Model)this, 0, 16);
        this.leftLeg.field_78809_i = true;
        this.leftLeg.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_i225946_2_);
        this.leftLeg.func_78793_a(1.9f, 12.0f + p_i225946_3_, 0.0f);
        this.hornright = new ModelRenderer((Model)this, 38, 2);
        this.hornright.func_228300_a_(-8.0f, 0.0f, 0.0f, 8.0f, 4.0f, 4.0f);
        this.hornright.func_78793_a(-4.0f, -8.0f, -2.0f);
        this.hornright.func_78787_b(64, 32);
        this.hornright.field_78809_i = true;
        this.setRotation(this.hornright, 0.0f, 0.0f, 0.0f);
        this.hornleft = new ModelRenderer((Model)this, 38, 2);
        this.hornleft.func_228300_a_(0.0f, 0.0f, 0.0f, 8.0f, 4.0f, 4.0f);
        this.hornleft.func_78793_a(4.0f, -8.0f, -2.0f);
        this.hornleft.func_78787_b(64, 32);
        this.hornleft.field_78809_i = true;
        this.setRotation(this.hornleft, 0.0f, 0.0f, 0.0f);
        this.head.func_78792_a(this.hornright);
        this.head.func_78792_a(this.hornleft);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.hat);
    }

    public void prepareMobModel(T p_212843_1_, float p_212843_2_, float p_212843_3_, float p_212843_4_) {
        this.swimAmount = p_212843_1_.func_205015_b(p_212843_4_);
        super.func_212843_a_(p_212843_1_, p_212843_2_, p_212843_3_, p_212843_4_);
    }

    public void setupAnim(T p_225597_1_, float p_225597_2_, float p_225597_3_, float p_225597_4_, float p_225597_5_, float p_225597_6_) {
        boolean flag3;
        boolean flag = p_225597_1_.func_184599_cB() > 4;
        boolean flag1 = p_225597_1_.func_213314_bj();
        this.head.field_78796_g = p_225597_5_ * ((float)Math.PI / 180);
        this.head.field_78795_f = flag ? -0.7853982f : (this.swimAmount > 0.0f ? (flag1 ? this.rotlerpRad(this.swimAmount, this.head.field_78795_f, -0.7853982f) : this.rotlerpRad(this.swimAmount, this.head.field_78795_f, p_225597_6_ * ((float)Math.PI / 180))) : p_225597_6_ * ((float)Math.PI / 180));
        this.body.field_78796_g = 0.0f;
        this.rightArm.field_78798_e = 0.0f;
        this.rightArm.field_78800_c = -5.0f;
        this.leftArm.field_78798_e = 0.0f;
        this.leftArm.field_78800_c = 5.0f;
        float f = 1.0f;
        if (flag) {
            f = (float)p_225597_1_.func_213322_ci().func_189985_c();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(p_225597_2_ * 0.6662f + (float)Math.PI)) * 2.0f * p_225597_3_ * 0.5f / f;
        this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(p_225597_2_ * 0.6662f)) * 2.0f * p_225597_3_ * 0.5f / f;
        this.rightArm.field_78808_h = 0.0f;
        this.leftArm.field_78808_h = 0.0f;
        this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(p_225597_2_ * 0.6662f)) * 1.4f * p_225597_3_ / f;
        this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(p_225597_2_ * 0.6662f + (float)Math.PI)) * 1.4f * p_225597_3_ / f;
        this.rightLeg.field_78796_g = 0.0f;
        this.leftLeg.field_78796_g = 0.0f;
        this.rightLeg.field_78808_h = 0.0f;
        this.leftLeg.field_78808_h = 0.0f;
        if (this.field_217113_d) {
            this.rightArm.field_78795_f += -0.62831855f;
            this.leftArm.field_78795_f += -0.62831855f;
            this.rightLeg.field_78795_f = -1.4137167f;
            this.rightLeg.field_78796_g = 0.31415927f;
            this.rightLeg.field_78808_h = 0.07853982f;
            this.leftLeg.field_78795_f = -1.4137167f;
            this.leftLeg.field_78796_g = -0.31415927f;
            this.leftLeg.field_78808_h = -0.07853982f;
        }
        this.rightArm.field_78796_g = 0.0f;
        this.leftArm.field_78796_g = 0.0f;
        boolean flag2 = p_225597_1_.func_184591_cq() == HandSide.RIGHT;
        boolean bl = flag3 = flag2 ? this.leftArmPose.func_241657_a_() : this.rightArmPose.func_241657_a_();
        if (flag2 != flag3) {
            this.poseLeftArm(p_225597_1_);
            this.poseRightArm(p_225597_1_);
        } else {
            this.poseRightArm(p_225597_1_);
            this.poseLeftArm(p_225597_1_);
        }
        this.setupAttackAnimation(p_225597_1_, p_225597_4_);
        if (this.crouching) {
            this.body.field_78795_f = 0.5f;
            this.rightArm.field_78795_f += 0.4f;
            this.leftArm.field_78795_f += 0.4f;
            this.rightLeg.field_78798_e = 4.0f;
            this.leftLeg.field_78798_e = 4.0f;
            this.rightLeg.field_78797_d = 12.2f;
            this.leftLeg.field_78797_d = 12.2f;
            this.head.field_78797_d = 4.2f;
            this.body.field_78797_d = 3.2f;
            this.leftArm.field_78797_d = 5.2f;
            this.rightArm.field_78797_d = 5.2f;
        } else {
            this.body.field_78795_f = 0.0f;
            this.rightLeg.field_78798_e = 0.1f;
            this.leftLeg.field_78798_e = 0.1f;
            this.rightLeg.field_78797_d = 12.0f;
            this.leftLeg.field_78797_d = 12.0f;
            this.head.field_78797_d = 0.0f;
            this.body.field_78797_d = 0.0f;
            this.leftArm.field_78797_d = 2.0f;
            this.rightArm.field_78797_d = 2.0f;
        }
        ModelHelper.func_239101_a_((ModelRenderer)this.rightArm, (ModelRenderer)this.leftArm, (float)p_225597_4_);
        if (this.swimAmount > 0.0f) {
            float f3;
            float f1 = p_225597_2_ % 26.0f;
            HandSide handside = this.getAttackArm(p_225597_1_);
            float f2 = handside == HandSide.RIGHT && this.field_217112_c > 0.0f ? 0.0f : this.swimAmount;
            float f4 = f3 = handside == HandSide.LEFT && this.field_217112_c > 0.0f ? 0.0f : this.swimAmount;
            if (f1 < 14.0f) {
                this.leftArm.field_78795_f = this.rotlerpRad(f3, this.leftArm.field_78795_f, 0.0f);
                this.rightArm.field_78795_f = MathHelper.func_219799_g((float)f2, (float)this.rightArm.field_78795_f, (float)0.0f);
                this.leftArm.field_78796_g = this.rotlerpRad(f3, this.leftArm.field_78796_g, (float)Math.PI);
                this.rightArm.field_78796_g = MathHelper.func_219799_g((float)f2, (float)this.rightArm.field_78796_g, (float)((float)Math.PI));
                this.leftArm.field_78808_h = this.rotlerpRad(f3, this.leftArm.field_78808_h, (float)Math.PI + 1.8707964f * this.quadraticArmUpdate(f1) / this.quadraticArmUpdate(14.0f));
                this.rightArm.field_78808_h = MathHelper.func_219799_g((float)f2, (float)this.rightArm.field_78808_h, (float)((float)Math.PI - 1.8707964f * this.quadraticArmUpdate(f1) / this.quadraticArmUpdate(14.0f)));
            } else if (f1 >= 14.0f && f1 < 22.0f) {
                float f6 = (f1 - 14.0f) / 8.0f;
                this.leftArm.field_78795_f = this.rotlerpRad(f3, this.leftArm.field_78795_f, 1.5707964f * f6);
                this.rightArm.field_78795_f = MathHelper.func_219799_g((float)f2, (float)this.rightArm.field_78795_f, (float)(1.5707964f * f6));
                this.leftArm.field_78796_g = this.rotlerpRad(f3, this.leftArm.field_78796_g, (float)Math.PI);
                this.rightArm.field_78796_g = MathHelper.func_219799_g((float)f2, (float)this.rightArm.field_78796_g, (float)((float)Math.PI));
                this.leftArm.field_78808_h = this.rotlerpRad(f3, this.leftArm.field_78808_h, 5.012389f - 1.8707964f * f6);
                this.rightArm.field_78808_h = MathHelper.func_219799_g((float)f2, (float)this.rightArm.field_78808_h, (float)(1.2707963f + 1.8707964f * f6));
            } else if (f1 >= 22.0f && f1 < 26.0f) {
                float f42 = (f1 - 22.0f) / 4.0f;
                this.leftArm.field_78795_f = this.rotlerpRad(f3, this.leftArm.field_78795_f, 1.5707964f - 1.5707964f * f42);
                this.rightArm.field_78795_f = MathHelper.func_219799_g((float)f2, (float)this.rightArm.field_78795_f, (float)(1.5707964f - 1.5707964f * f42));
                this.leftArm.field_78796_g = this.rotlerpRad(f3, this.leftArm.field_78796_g, (float)Math.PI);
                this.rightArm.field_78796_g = MathHelper.func_219799_g((float)f2, (float)this.rightArm.field_78796_g, (float)((float)Math.PI));
                this.leftArm.field_78808_h = this.rotlerpRad(f3, this.leftArm.field_78808_h, (float)Math.PI);
                this.rightArm.field_78808_h = MathHelper.func_219799_g((float)f2, (float)this.rightArm.field_78808_h, (float)((float)Math.PI));
            }
            float f7 = 0.3f;
            float f5 = 0.33333334f;
            this.leftLeg.field_78795_f = MathHelper.func_219799_g((float)this.swimAmount, (float)this.leftLeg.field_78795_f, (float)(0.3f * MathHelper.func_76134_b((float)(p_225597_2_ * 0.33333334f + (float)Math.PI))));
            this.rightLeg.field_78795_f = MathHelper.func_219799_g((float)this.swimAmount, (float)this.rightLeg.field_78795_f, (float)(0.3f * MathHelper.func_76134_b((float)(p_225597_2_ * 0.33333334f))));
        }
        this.hat.func_217177_a(this.head);
    }

    private void poseRightArm(T p_241654_1_) {
        switch (this.rightArmPose) {
            case EMPTY: {
                this.rightArm.field_78796_g = 0.0f;
                break;
            }
            case BLOCK: {
                this.rightArm.field_78795_f = this.rightArm.field_78795_f * 0.5f - 0.9424779f;
                this.rightArm.field_78796_g = -0.5235988f;
                break;
            }
            case ITEM: {
                this.rightArm.field_78795_f = this.rightArm.field_78795_f * 0.5f - 0.31415927f;
                this.rightArm.field_78796_g = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.rightArm.field_78795_f = this.rightArm.field_78795_f * 0.5f - (float)Math.PI;
                this.rightArm.field_78796_g = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.rightArm.field_78796_g = -0.1f + this.head.field_78796_g;
                this.leftArm.field_78796_g = 0.1f + this.head.field_78796_g + 0.4f;
                this.rightArm.field_78795_f = -1.5707964f + this.head.field_78795_f;
                this.leftArm.field_78795_f = -1.5707964f + this.head.field_78795_f;
                break;
            }
            case CROSSBOW_CHARGE: {
                ModelHelper.func_239102_a_((ModelRenderer)this.rightArm, (ModelRenderer)this.leftArm, p_241654_1_, (boolean)true);
                break;
            }
            case CROSSBOW_HOLD: {
                ModelHelper.func_239104_a_((ModelRenderer)this.rightArm, (ModelRenderer)this.leftArm, (ModelRenderer)this.head, (boolean)true);
            }
        }
    }

    private void poseLeftArm(T p_241655_1_) {
        switch (this.leftArmPose) {
            case EMPTY: {
                this.leftArm.field_78796_g = 0.0f;
                break;
            }
            case BLOCK: {
                this.leftArm.field_78795_f = this.leftArm.field_78795_f * 0.5f - 0.9424779f;
                this.leftArm.field_78796_g = 0.5235988f;
                break;
            }
            case ITEM: {
                this.leftArm.field_78795_f = this.leftArm.field_78795_f * 0.5f - 0.31415927f;
                this.leftArm.field_78796_g = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.leftArm.field_78795_f = this.leftArm.field_78795_f * 0.5f - (float)Math.PI;
                this.leftArm.field_78796_g = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.rightArm.field_78796_g = -0.1f + this.head.field_78796_g - 0.4f;
                this.leftArm.field_78796_g = 0.1f + this.head.field_78796_g;
                this.rightArm.field_78795_f = -1.5707964f + this.head.field_78795_f;
                this.leftArm.field_78795_f = -1.5707964f + this.head.field_78795_f;
                break;
            }
            case CROSSBOW_CHARGE: {
                ModelHelper.func_239102_a_((ModelRenderer)this.rightArm, (ModelRenderer)this.leftArm, p_241655_1_, (boolean)false);
                break;
            }
            case CROSSBOW_HOLD: {
                ModelHelper.func_239104_a_((ModelRenderer)this.rightArm, (ModelRenderer)this.leftArm, (ModelRenderer)this.head, (boolean)false);
            }
        }
    }

    protected void setupAttackAnimation(T p_230486_1_, float p_230486_2_) {
        if (!(this.field_217112_c <= 0.0f)) {
            HandSide handside = this.getAttackArm(p_230486_1_);
            ModelRenderer modelrenderer = this.getArm(handside);
            float f = this.field_217112_c;
            this.body.field_78796_g = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)f) * ((float)Math.PI * 2))) * 0.2f;
            if (handside == HandSide.LEFT) {
                this.body.field_78796_g *= -1.0f;
            }
            this.rightArm.field_78798_e = MathHelper.func_76126_a((float)this.body.field_78796_g) * 5.0f;
            this.rightArm.field_78800_c = -MathHelper.func_76134_b((float)this.body.field_78796_g) * 5.0f;
            this.leftArm.field_78798_e = -MathHelper.func_76126_a((float)this.body.field_78796_g) * 5.0f;
            this.leftArm.field_78800_c = MathHelper.func_76134_b((float)this.body.field_78796_g) * 5.0f;
            this.rightArm.field_78796_g += this.body.field_78796_g;
            this.leftArm.field_78796_g += this.body.field_78796_g;
            this.leftArm.field_78795_f += this.body.field_78796_g;
            f = 1.0f - this.field_217112_c;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = MathHelper.func_76126_a((float)(f * (float)Math.PI));
            float f2 = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -(this.head.field_78795_f - 0.7f) * 0.75f;
            modelrenderer.field_78795_f = (float)((double)modelrenderer.field_78795_f - ((double)f1 * 1.2 + (double)f2));
            modelrenderer.field_78796_g += this.body.field_78796_g * 2.0f;
            modelrenderer.field_78808_h += MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -0.4f;
        }
    }

    protected float rotlerpRad(float p_205060_1_, float p_205060_2_, float p_205060_3_) {
        float f = (p_205060_3_ - p_205060_2_) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return p_205060_2_ + p_205060_1_ * f;
    }

    private float quadraticArmUpdate(float p_203068_1_) {
        return -65.0f * p_203068_1_ + p_203068_1_ * p_203068_1_;
    }

    public void copyPropertiesTo(BipedModel<T> p_217148_1_) {
        super.func_217111_a(p_217148_1_);
        p_217148_1_.field_187075_l = this.leftArmPose;
        p_217148_1_.field_187076_m = this.rightArmPose;
        p_217148_1_.field_228270_o_ = this.crouching;
        p_217148_1_.field_78116_c.func_217177_a(this.head);
        p_217148_1_.field_178720_f.func_217177_a(this.hat);
        p_217148_1_.field_78115_e.func_217177_a(this.body);
        p_217148_1_.field_178723_h.func_217177_a(this.rightArm);
        p_217148_1_.field_178724_i.func_217177_a(this.leftArm);
        p_217148_1_.field_178721_j.func_217177_a(this.rightLeg);
        p_217148_1_.field_178722_k.func_217177_a(this.leftLeg);
    }

    public void setAllVisible(boolean p_178719_1_) {
        this.head.field_78806_j = p_178719_1_;
        this.hat.field_78806_j = p_178719_1_;
        this.body.field_78806_j = p_178719_1_;
        this.rightArm.field_78806_j = p_178719_1_;
        this.leftArm.field_78806_j = p_178719_1_;
        this.rightLeg.field_78806_j = p_178719_1_;
        this.leftLeg.field_78806_j = p_178719_1_;
    }

    private void setRotation(ModelRenderer var1, float var2, float var3, float var4) {
        var1.field_78795_f = var2;
        var1.field_78796_g = var3;
        var1.field_78808_h = var4;
    }

    public void func_225599_a_(HandSide p_225599_1_, MatrixStack p_225599_2_) {
        this.getArm(p_225599_1_).func_228307_a_(p_225599_2_);
    }

    protected ModelRenderer getArm(HandSide p_187074_1_) {
        return p_187074_1_ == HandSide.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelRenderer func_205072_a() {
        return this.head;
    }

    protected HandSide getAttackArm(T p_217147_1_) {
        HandSide handside = p_217147_1_.func_184591_cq();
        return ((LivingEntity)p_217147_1_).field_184622_au == Hand.MAIN_HAND ? handside : handside.func_188468_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum ArmPose {
        EMPTY(false),
        ITEM(false),
        BLOCK(false),
        BOW_AND_ARROW(true),
        THROW_SPEAR(false),
        CROSSBOW_CHARGE(true),
        CROSSBOW_HOLD(true);

        private final boolean twoHanded;

        private ArmPose(boolean p_i241257_3_) {
            this.twoHanded = p_i241257_3_;
        }

        public boolean isTwoHanded() {
            return this.twoHanded;
        }
    }
}

